/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

   Build: make chk_date
*/
#include "wxdate.h"
#include <iostream>

#if WXDATE_VERSION!=8
#error Test code is for WXDATE_VERSION 8
#endif

//
// The seconds since 1970-1-1 due zero o'clock not representible by WxDate
//
static const WxTime::SecsType OverDateSecs=((long long)LONG_MAX)<<1;

static bool chk_default(const WxDate& date)
{
 const static WxDate D0;
 if(date.utc_time().nano()!=0) {
   WX_THROW( Wx_general_error() );
 }
 if(date.is_default()==false) {
   return(false);
 }
 if(date==D0) {
 } else {
 }
 if(date!=D0) {
   return(false);
 }
 if(date.year()!=1970) {
   return(false);
 }
 if(date.month()!=1) {
   return(false);
 }
 if(date.mday()!=1) {
   return(false);
 }
 if(date.hour()!=0) {
   return(false);
 }
 if(date.min()!=0) {
   return(false);
 }
 if(date.sec()!=0) {
   return(false);
 }
 if(date.wday()!=4) {
   return(false);
 }
 if(date.yday()!=0) {
   return(false);
 }
 if(date.utc_time()!=WxTime()) {
   return(false);
 }
 return(true);
};

static bool chk_not_default(const WxDate& date)
{
 return !chk_default(date);
};

static bool chk_equ(const WxDate& d1, const WxDate& d2)
{
 if(d1.utc_time().nano()!=0) {
   WX_THROW( Wx_general_error() );
 }
 if(d2.utc_time().nano()!=0) {
   WX_THROW( Wx_general_error() );
 }
 if(d1==d2) {
 } else {
   return(false);
 }
 if(d1!=d2) {
   return(false);
 }
 if(d1.year()!=d2.year()) {
   return(false);
 }
 if(d1.month()!=d2.month()) {
   return(false);
 }
 if(d1.mday()!=d2.mday()) {
   return(false);
 }
 if(d1.hour()!=d2.hour()) {
   return(false);
 }
 if(d1.min()!=d2.min()) {
   return(false);
 }
 if(d1.sec()!=d2.sec()) {
   return(false);
 }
 if(d1.wday()!=d2.wday()) {
   return(false);
 }
 if(d1.yday()!=d2.yday()) {
   return(false);
 }
 if(d1.utc_time()!=d2.utc_time()) {
   return(false);
 }
 return(true);
};

static bool chk_not_equ(const WxDate& d1, const WxDate& d2)
{
 return !chk_equ(d1,d2);
};

#define CHK_EQU(expr1,expr2) if(chk_equ(expr1,expr2)==false) { WX_THROW( Wx_general_error() ); };
#define CHK_NOT_EQU(expr1,expr2) if(chk_not_equ(expr1,expr2)==false) { WX_THROW( Wx_general_error() ); };

#define CHK_DEFAULT(expr) if(chk_default(expr)==false) { WX_THROW( Wx_general_error() ); };
#define CHK_NOT_DEFAULT(expr) if(chk_not_default(expr)==false) { WX_THROW( Wx_general_error() ); };

//
//   Test WxDate (set_systime() not tested)
//
static void t_date1(void)
{
 WxRet r;
 WxDate a,b(WxTime(0,0));

 //
 // Chech the default setting and basic test
 //
 CHK_DEFAULT(a);
 CHK_DEFAULT(b);

 CHK_EQU(a,b);

 //
 // Test constructor
 //
 WxDate c(WxTime(10,10)),d(c);
 CHK_NOT_EQU(c,a);
 CHK_EQU(c,d);
 CHK_NOT_DEFAULT(d);

 if(d.utc_time().secs()!=10) {
   WX_THROW( Wx_general_error() );
 }
 if(d.utc_time().nano()!=0) {
   WX_THROW( Wx_general_error() );
 }

 //
 // check reset
 //
 { 
   WxDate dat1,dat2(WxTime(100,100));
   CHK_DEFAULT(dat1);
   CHK_NOT_DEFAULT(dat2);
   dat2.reset();
   CHK_DEFAULT(dat2);
 }

 //
 // Test assign
 //
 if(b==d) {
   WX_THROW( Wx_general_error() );
 }
 b.assign(d);
 CHK_EQU(b,d);

 if((r=b.assign(WxTime(100,100)))!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if(b.utc_time()!=WxTime(100,0)) {
   WX_THROW( Wx_general_error() );
 }
 if(b!=WxTime(100,100)) {
   WX_THROW( Wx_general_error() );
 }
 if((r=b.assign(2003,9,20,16,39,1))!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if(b.year()!=2003) {
   WX_THROW( Wx_general_error() );
 }
 if(b.month()!=9) {
   WX_THROW( Wx_general_error() );
 }
 if(b.mday()!=20) {
   WX_THROW( Wx_general_error() );
 }
 if(b.hour()!=16) {
   WX_THROW( Wx_general_error() );
 }
 if(b.min()!=39) {
   WX_THROW( Wx_general_error() );
 }
 if(b.sec()!=1) {
   WX_THROW( Wx_general_error() );
 }
 if(b.wday()!=6) {
   WX_THROW( Wx_general_error() );
 }
 
 //
 // Test operator=
 //
 CHK_NOT_EQU(b,d);
 b=d;
 CHK_EQU(b,d);

 b=WxTime(50,50);
 if(b.utc_time()!=WxTime(50,0)) {
   WX_THROW( Wx_general_error() );
 }
 if(b!=WxTime(50,0)) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test add
 //
 b=WxTime(50,50);
 if((r=b.add(WxTime(50,50)))!=OK) {
   WX_HERE(r); throw(r);
 }
 if(b!=WxTime(100,100)) {
   WX_THROW( Wx_general_error() );
 }
 if((r=b.assign(2000,2,28,12,0,0))!=OK) {
   WX_THROW( Wx_general_error() );
 }
/*
 if((r=b.add(0,0,0,12,0,0))!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if(b!=WxDate(2000,2,29,0,0,0)) {
   WX_THROW( Wx_general_error() );
 }
 if((r=b.add(0,0,0,12,0,0))!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if(b!=WxDate(2000,2,29,12,0,0)) {
   WX_THROW( Wx_general_error() );
 }
 if((r=b.add(0,0,0,12,0,0))!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if(b!=WxDate(2000,3,1,0,0,0)) {
   WX_THROW( Wx_general_error() );
 }
 // not leap year
 if((r=b.assign(2001,2,28,12,0,0))!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if((r=b.add(0,0,0,12,0,0))!=OK) {
   WX_THROW( Wx_general_error() );
 }
 if(b!=WxDate(2001,3,1,0,0,0)) {
   WX_THROW( Wx_general_error() );
 }
*/
 //
 // Test operator+=
 //
 b=WxTime(50,50);
 b+=WxTime(50,50);
 if(b!=WxTime(100,100)) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test comparison
 //
 if((r=a.assign(1999,9,9,0,0,0))!=OK) {
   WX_HERE(r); throw(r);
 }
 if((r=b.assign(1999,9,9,0,0,1))!=OK) {
   WX_HERE(r); throw(r);
 }
 if((r=c.assign(1999,9,9,0,1,0))!=OK) {
   WX_HERE(r); throw(r);
 }
 if((r=d.assign(1999,9,9,1,0,0))!=OK) {
   WX_HERE(r); throw(r);
 }
 if((a>b)||(b>c)||(c>d)) {
   WX_THROW( Wx_general_error() );
 }
 if((a>=b)||(b>=c)||(c>=d)) {
   WX_THROW( Wx_general_error() );
 }
 if((d<c)||(c<b)||(b<a)) {
   WX_THROW( Wx_general_error() );
 }
 if((d<=c)||(c<=b)||(b<=a)) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test feature of ::mktime (minimum time)
 //
 if((r=a.assign(1970,1,1,0,0,0))!=OK) {
   WX_HERE(r); throw(r);
 }
 if(a.utc_time()!=WxTime()) {
   WX_THROW( Wx_general_error() );
 }
 if((r=a.assign(1970,1,1,8,0,0))!=OK) {
   WX_HERE(r); throw(r);
 }
 if(a.utc_time()!=WxTime(8*60*60L,0)) {
   WX_THROW( Wx_general_error() );
 }
 if((a.year()!=1970)||
    (a.month()!=1)||
    (a.mday()!=1)||
    (a.hour()!=8)||
    (a.min()!=0)||
    (a.sec()!=0)) {
   WX_THROW( Wx_general_error() );
 }
 if((r=a.add(WxTime(60*60+60+1,1)))!=OK) {
   WX_HERE(r); throw(r);
 }
 if((a.year()!=1970)||
    (a.month()!=1)||
    (a.mday()!=1)||
    (a.hour()!=9)||
    (a.min()!=1)||
    (a.sec()!=1)) {
   WX_THROW( Wx_general_error() );
 }

 //
 // Test mis. 
 //
 {
  WxDate tm(Wx::now());
  if((r=b.assign(2003,9,20,16,39,0))!=OK) {  // that's about yestoday
    WX_HERE(r); throw(r);
  }
  if(tm<b) {
   WX_THROW( Wx_general_error() );  // system time not properly set
  }
  if((r=b.assign(2038,1,1,0,0,0))!=OK) {  // that's about current limit
    WX_HERE(r); throw(r);
  }
  if(tm>b) {
   WX_THROW( Wx_general_error() );  // system time not properly set
  }
 }

};

static void t_date2(void)
{
 WxRet r;
 WxDate d1,d2;

 try {
   WxDate tt(WxTime(OverDateSecs,LONG_MAX));  // should not be representable in this time
   std::cerr << Wx::what_is(tt) << std::endl;
   WX_THROW( Wx_general_error() ); 
 }
 catch(const WxDate::Fault& e) {
   if(e!=WXM_ERANGE) {
     WX_HERE(r); throw(r);
   }
 };

 if((r=d1.assign(1999,1,1,0,0,-1))!=WXM_EINVAL) {  // Invalid argument
     WX_HERE(r); throw(r);
 }
 if((r=d1.assign(3000,1,1,0,0,0))!=WXM_ERANGE) {  // not representable now
     WX_HERE(r); throw(r);
 }
 if((r=d1.assign(WxTime(OverDateSecs,LONG_MAX)))!=WXM_ERANGE) {
     WX_HERE(r); throw(r);
 }

 try {
   d1=WxTime(OverDateSecs,LONG_MAX);  // should not be representable in this time
   WX_THROW( Wx_general_error() ); 
 }
 catch(const WxDate::Fault& e) {
   if(e!=WXM_ERANGE) {
     WX_HERE(r); throw(r);
   }
 };

 if((r=d2.assign(2037,1,1,8,59,59))!=OK) {
   WX_HERE(r); throw(r);
 }
 d1=d2;
 if((r=d1.add(WxTime(315360000,0)))!=WXM_ERANGE) { // add about 10 year
   WX_HERE(r); throw(r);
 }
 CHK_EQU(d1,d2);    // failure should not modify

 // condition for the next test
 if((d1.hour()!=8)||(d1.min()!=59)||(d1.sec()!=59)) {
   WX_THROW( Wx_general_error() ); 
 }
 if((r=d1.add(WxTime(1,1)))!=OK) {  // roundup nano test
   WX_HERE(r); throw(r);
 }
 if((d1.hour()!=9)||(d1.min()!=0)||(d1.sec()!=0)) {
   WX_THROW( Wx_general_error() ); 
 }

 if((r=d1.assign(2038,1,1,0,0,0))!=OK) {
   WX_HERE(r); throw(r);
 }
 try {
   d1+=d1.utc_time();  // should not be representable in this time (+=1970 year)
   WX_THROW( Wx_general_error() ); 
 }
 catch(const WxDate::Fault& e) {
   if(e!=WXM_ERANGE) {
    WxRet r=e;
    WX_HERE(r); throw(r);
   }
 };
};

static const WxStr chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking wxdate.h ...\n";
 if(std::strcmp(WxDate::class_name,"WxDate")!=0) {
   WX_THROW( Wx_general_error() );
 }
 t_date1();
 t_date2();
 {
  WxDate tt(Wx::now());
  std::cout << "now()=  "<< Wx::what_is(tt) << std::endl;
 }
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
