/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)

  Note: The check is few because no thread available yet.

  Build: make chk_cond
*/

#include "wxret.h"
#include "wxcond.h"

#if WXCOND_VERSION!=8
#error Test code is for WXCOND_VERSION 8
#endif

//
// Test WxCond
//
static void t1(void)
{
 WxRet r;
 WxCond cond;
 WxMutex mtx;
 
 //if((r=cond.reset())!=OK) {
 //  WX_HERE(r); throw(r);
 //}

 cond.signal();       // just to make sure this function exists
 cond.broadcast();

 //
 // Check timedwait
 //
 {
  WxLock aa(mtx);
  WxTime t1=Wx::now()+WxTime(1,0);
  if((r=cond.wait(aa,t1))!=WXM_ETIMEDOUT) {
    WX_HERE(r); throw(r);
  }
  WxTime t2=Wx::now();
  if((t2-t1).abs()>WxTime(0,60000000)) {
    WX_THROW( Wx_general_error() );    // error > 0.06sec
  }
 }
};

static const WxStr chdr(
                  "+-------------------------+\n"
                  "| main() caught exception:|\n"
                  "+-------------------------+\n");
int main(void) throw()
try {
 std::cout << "Checking wxcond.cpp ...\n";
 if(WxStr(WxCond::class_name)!="WxCond") {
   WX_THROW( Wx_general_error() );
 }
 t1(); 
 std::cout << "Checked OK\n";
 return(0);
}
catch(const WxRet& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_general_error& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_errno& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_except& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const Wx_bad_alloc& e) {
 std::cerr << chdr << Wx::what_is(e) << std::endl;
 return(-1);
}
catch(const std::exception& e) {
 std::cerr << chdr << "std::exception" << std::endl;
 return(-1);
}
catch(...) {
 std::cerr << chdr << "unknown exception" << std::endl;
 return(-1);
};
