/*
   error.c -- Error messages & functions
   
   SNDCAP Voice Capture Library
   
   Copyright (C) 2007 Laszlo Menczel
   
   This is free software with NO WARRANTY. Distributed under
   the GNU Library General Public Licence (LGPL) version 2.1.
*/

#include <stdio.h>

#include "sndcap.h"
#include "sndcaplib.h"

//============================================================================

static char sbuf[512];

static char *bad_err = "Unknown error (code out of range)";

static char *errmsg[CAPERR_ERR_NUM] =
{
  "no error",

  // capture
  "capture module not initialized",
  "bad argument",
  "memory allocation error",
  "NULL pointer argument",
  "bad ring buffer (data block NULL or increment out of range)",
  "cannot open capture device",
  "currently recording sound",
  "not recording sound"
  "could not start sound capture",
  "could not add capture buffer buffer to queue",
  "could not create the capture thread",
  
  // ringbuffer
  "bad argument",
  "buffer data block is NULL",
  "buffer structure is static (not allocated by the library)",
  "buffer is empty",

  // WAV
  "bad file name (empty)",
  "could not open/create the specified file",
  "failed reading data from the file",
  "failed writing data to the file",
  "not a RIFF file",
  "not a WAVE file",
  "'fmt' chunk not found",
  "cannot load compressed WAV",
  "bad channel number (should be 1 or 2)",
  "'data' chunk not found",
  "bad data size (should be 8 or 16 bits)",
  "bad sampling rate (should be 8000, 11025, 22050 or 44100)",
  "missing sound samples",
  "same WAV format (conversion is pointless)",
  "this function is not implemented yet"
};

//============================================================================

int scap_last_error(void)
{
  return __scap_err;
}

//============================================================================

char *scap_errmsg(int code)
{
  if (code < 0 || code > CAPERR_ERR_NUM)
    sprintf(sbuf, "SCAP: %s", bad_err);
  else
    sprintf(sbuf, "SCAP: %s", errmsg[code]);
  
  return sbuf;
}
