echo off

if not %MINGW%=="" goto path_ok
echo You should set the environmental variable MINGW to the location
echo of your MinGW installation (e.g. c:\mingw).
goto finish

:path_ok
if exist %MINGW%\bin\mingw32-make.exe goto make_ok
echo Cannot locate the MAKE utility of MinGW.
echo The path in the variable MINGW may be incorrect.
goto finish

:make_ok
echo Making capture test program...
if exist 0msg0 del 0msg0
if exist 0err0 del 0err0
..\util\redir.exe -o 0msg0 -e 0err0 %MINGW%\bin\mingw32-make.exe captest CCDIR=%MINGW%
if errorlevel 1 goto err_exit
echo OK
goto finish

:err_exit
..\util\win32pad 0err0

:finish
pause
