//
// FILE:
// errlog.C
//
// FUNCTION:
// The linErrLog class provides some simple error logging
// facilities.  See the header file for further 
// documentation.
//
// HISTORY:
// Copyright (c) 1995, 1997 Linas Vepstas linas@linas.org
// Released under the  conditions  of  the  GNU General 
// Public License.

#include <stdarg.h>

#include "errlog.h"

// ============================================================

linErrLog::linErrLog (void)
{
   errf = stdout;
   loglevel = SEVERE;
   enabled = 1;
   scope = 0x0;
}

linErrLog::~linErrLog ()
{
   errf = stdout;
   loglevel = SEVERE;
   enabled = 1;
   scope = 0x0;
}

// ============================================================

void linErrLog::SetLogLevel (severity lvl)
{
   loglevel = lvl;
}

linErrLog::severity linErrLog::GetLogLevel (void)
{
   return loglevel;
}

// ============================================================

void linErrLog::PrtErr (severity lvl, char * fmt, ...)
{
   if (enabled && (lvl <= loglevel)) {
      switch (lvl) {
         case FATAL:
            fprintf (errf, "Fatal Error: ");
            break;
         case SEVERE:
            fprintf (errf, "Error: ");
            break;
         case WARN:
            fprintf (errf, "Warning: ");
            break;
         case INFO:
            fprintf (errf, "Info:  ");
            break;
         case DEBUG:
            fprintf (errf, "Debug: ");
            break;
         case TRACE:
            fprintf (errf, "Trace: ");
            break;
      }

      if (scope) fprintf (errf, "%s: ", scope);

      va_list ap;
      va_start (ap, fmt);
      vfprintf (errf, fmt, ap);
      // flush the output stream so that 
      // its immediately readable 
      fflush (errf);
   }
}

// ============================================================

void linErrLog::PrtMore (severity lvl, char * fmt, ...)
{
   if (enabled && (lvl <= loglevel)) {
      va_list ap;
      va_start (ap, fmt);
      vfprintf (errf, fmt, ap);
      // flush the output stream so that 
      // its immediately readable 
      fflush (errf);
   }
}

// ================== END OF FILE =============================
