/* include/structs.h -- private header for libretto, defining structures
 *
 * Aaron Crane <aaronc@pobox.com>
 * 14 March 1998
 *
 * This file is part of Libretto, a library of useful functions.
 * Libretto is Copyright  1996, 1997, 1998 Aaron Crane <aaronc@pobox.com>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

struct autostr
{
    char *s;
    ssize_t length;
    ssize_t alloced;
};

struct autobuf
{
    ssize_t length;
    unsigned char *data;
    ssize_t alloced;
};

struct darray
{
    ssize_t length;
    unsigned char *data;
    ssize_t alloced;
    size_t obj_size;
};

struct chainlink
{
    void *data;
    Chainlink *prev;
    Chainlink *next;
};

struct chain
{
    ssize_t length;
    Chainlink *first;
    Chainlink *last;
#if 0
    /* These aren't yet implemented.  The idea is that the last `Nth' node
     * looked up will be cached here, for easier indexing with access
     * patterns that approach sequential.  Of course, I'll have to be
     * careful that whenever an operation is performed which could mung the
     * cache, the cache is either invalidated or frobbed appropriately.
     *
     * Note the great advantage of *really* abstracting Libretto's types:
     * since users only know about pointers to types, I will be able to
     * freely change the structure definitions without breaking programs.
     */
    ssize_t cached_index;
    Chainlink *cached;
#endif
};

struct bstnode
{
    void *data;
    Bstnode *left;
    Bstnode *right;
    Bstnode *parent;	/* make Knuth's P$ operation trivial */
};

struct bstree
{
    Bstnode *root;
    Bst_compare_f cmp;
};
