/* libretto/darray.h -- public header for libretto's darray functions
 *
 * Aaron Crane <aaronc@pobox.com>
 * 12 April 1998
 *
 * This file is part of Libretto, a library of useful functions.
 * Libretto is Copyright  1996, 1997, 1998 Aaron Crane <aaronc@pobox.com>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBRETTO__DARRAY_HEADER_SEEN
#define LIBRETTO__DARRAY_HEADER_SEEN

#ifndef LIBRETTO__MAIN_HEADER_SEEN
#include <libretto/libretto.h>
#endif


__BEGIN_DECLS

/* Structors */
Darray *da_create __P ((size_t obj_size));
Darray *da_create_len __P ((size_t obj_size, ssize_t len));
void da_destroy __P ((Darray *da));

/* Status */
ssize_t da_length __P ((const Darray *da));
size_t da_object_size __P ((const Darray *da));
int da_equal __P ((const Darray *left, const Darray *right,
		   Da_compare_f cmp, void *cmp_args));
int da_valid_p __P ((const Darray *da));

/* Indexing and updating */
void *da_ref __P ((const Darray *da, ssize_t index));
void da_set __P ((Darray *da, ssize_t index, const void *node));
void *da_last __P ((const Darray *da));

/* Node swapping */
void da_exchange __P ((Darray *da, ssize_t x, ssize_t y));

/* Manipulations which change da_length (DA) */
ssize_t da_append __P ((Darray *da, const void *node));
int da_resize __P ((Darray *da, ssize_t newlen));
int da_insert __P ((Darray *da, ssize_t index, const void *node));
void da_delete __P ((Darray *da, ssize_t index));
int da_concat_da __P ((Darray *dest, const Darray *src));
int da_insert_da __P ((Darray *dest, const Darray *src, ssize_t index));
void da_prune __P ((Darray *da, Da_prune_f pruner, void *args));

/* Search and sort */
ssize_t da_find __P ((const Darray *da, ssize_t offset, const void *target,
		      Da_compare_f cmp, void *cmp_args));
ssize_t da_rfind __P ((const Darray *da, ssize_t last_found_offset,
		       const void *target, Da_compare_f cmp, void *cmp_args));
ssize_t da_bsearch __P ((const Darray *da, const void *target, Da_compare_f cmp,
			 void *cmp_args));
ssize_t da_bsearch_lim __P ((const Darray *da, ssize_t lower, ssize_t upper,
			     const void *target, Da_compare_f cmp, void *cmp_args));
ssize_t da_bsearch_index __P ((const Darray *da, const void *target, Da_compare_f cmp,
			       void *cmp_args));
void da_sort __P ((Darray *da, Da_compare_f cmp, void *cmp_args));
void da_reheap __P ((Darray *da, Da_compare_f cmp, void *cmp_args));

/* Other functions */
int da_apply __P ((const Darray *da, Da_apply_f func, void *apply_args));

/* Stack functions */
int da_push __P ((Darray *da, const void *elt));
void da_pop __P ((Darray *da, void *elt_buf));
void da_drop __P ((Darray *da));
void *da_top __P ((const Darray *da));
void da_swap __P ((Darray *da));
int da_dup __P ((Darray *da));
int da_empty __P ((const Darray *da));

__END_DECLS


#endif /* ! LIBRETTO__DARRAY_HEADER_SEEN */
