/* libretto/chain.h -- public header for libretto's chain functions
 *
 * Aaron Crane <aaronc@pobox.com>
 * 12 April 1998
 *
 * This file is part of Libretto, a library of useful functions.
 * Libretto is Copyright  1996, 1997, 1998 Aaron Crane <aaronc@pobox.com>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBRETTO__CHAIN_HEADER_SEEN
#define LIBRETTO__CHAIN_HEADER_SEEN

#ifndef LIBRETTO__MAIN_HEADER_SEEN
#include <libretto/libretto.h>
#endif


__BEGIN_DECLS

/* Structors */
Chain *chain_create __P ((void));
void chain_destroy __P ((Chain *chain));

/* Status */
ssize_t chain_length __P ((const Chain *chain));
void *chainlink_data __P ((const Chainlink *node));
int chain_valid_p __P ((const Chain *chain));

/* Traversal */
void chain_walk __P ((const Chain *chain, Chain_walk_f walker, void *params));
void chain_rwalk __P ((const Chain *chain, Chain_walk_f walker, void *params));

/* Chains as sorted linked lists */
Chainlink *chain_insert __P ((Chain *chain, void *data,
			      Chain_compare_f compare, void *cmp_args));

/* Chains as stacks: insert/remove at front */
Chainlink *chain_push __P ((Chain *chain, void *data));
void *chain_pop __P ((Chain *chain));
Chainlink *chain_top __P ((const Chain *chain));
void chain_drop __P ((Chain *chain));

/* Chains as queues: insert at end, remove at start */
Chainlink *chain_enqueue __P ((Chain *chain, void *data)); /* == chain_push() */
void *chain_dequeue __P ((Chain *chain));

/* Insert at end */
Chainlink *chain_append __P ((Chain *chain, void *data));

/* Insert at stated end */
Chainlink *chain_front_insert __P ((Chain *chain, void *data));
Chainlink *chain_back_insert __P ((Chain *chain, void *data));
void *chain_front_remove __P ((Chain *chain));
void *chain_back_remove __P ((Chain *chain));

/* Selectors */
Chainlink *chain_front __P ((const Chain *chain));
Chainlink *chain_first __P ((const Chain *chain));
Chainlink *chain_rear __P ((const Chain *chain));
Chainlink *chain_last __P ((const Chain *chain));
Chainlink *chain_nth __P ((const Chain *chain, ssize_t n));
Chainlink *chain_pred __P ((const Chain *chain, const Chainlink *node));
Chainlink *chain_succ __P ((const Chain *chain, const Chainlink *node));
Chainlink *chain_cpred __P ((const Chain *chain, const Chainlink *node));
Chainlink *chain_csucc __P ((const Chain *chain, const Chainlink *node));
Chainlink *chain_find __P ((const Chain *chain, const Chainlink *last_node,
			    const void *target, Chain_compare_f cmp, void *params));
Chainlink *chain_rfind __P ((const Chain *chain, const Chainlink *last_node,
			     const void *target, Chain_compare_f cmp, void *params));
int chain_member __P ((const Chain *chain, const Chainlink *node));

/* Node moving */
void chain_move_front __P ((Chain *chain, Chainlink *node));
void chain_move_back __P ((Chain *chain, Chainlink *node));

/* Deletion */
void chain_remove __P ((Chain *chain, Chainlink *node));
void chain_wipe __P ((Chain *chain));
void chain_prune __P ((Chain *chain, Chain_prune_f pruner, void *params));

/* Whole-chain manipulation */
int chain_concat_chain __P ((Chain *dest, const Chain *src));
void chain_reverse __P ((Chain *dest));

__END_DECLS


#endif /* ! LIBRETTO__CHAIN_HEADER_SEEN */
