/* libretto/bstree.h -- public header for libretto's bstree functions
 *
 * Aaron Crane <aaronc@pobox.com>
 * 12 April 1998
 *
 * This file is part of Libretto, a library of useful functions.
 * Libretto is Copyright  1996, 1997, 1998 Aaron Crane <aaronc@pobox.com>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBRETTO__BSTREE_HEADER_SEEN
#define LIBRETTO__BSTREE_HEADER_SEEN

#ifndef LIBRETTO__MAIN_HEADER_SEEN
#include <libretto/libretto.h>
#endif


__BEGIN_DECLS

/* Structors */
Bstree *bst_create __P ((Bst_compare_f compare));
void bst_destroy __P ((Bstree *bst));

/* Tree status */
ssize_t bst_nodes __P ((const Bstree *bst));
ssize_t bst_depth __P ((const Bstree *bst));
void *bstnode_data __P ((const Bstnode *node));
int bst_valid_p __P ((const Bstree *bst));

/* Tree traversal */
void bst_walk __P ((const Bstree *bst, Bst_walk_f walker, void *walk_args));
void bst_walk_pre __P ((const Bstree *bst, Bst_walk_f walker, void *walk_args));
void bst_walk_post __P ((const Bstree *bst, Bst_walk_f walker, void *walk_args));
Bstnode *bst_succ __P ((const Bstree *bst, const Bstnode *node));
Bstnode *bst_pred __P ((const Bstree *bst, const Bstnode *node));

/* Inserting (sortedly) */
Bstnode *bst_insert __P ((Bstree *bst, void *data, void *cmp_args));

/* Search */
Bstnode *bst_lookup __P ((const Bstree *bst, void *target, void *cmp_args));

/* Delete */
void bst_delete __P ((Bstree *bst, Bstnode *node, void *cmp_args));
void bst_wipe __P ((Bstree *bst));
void bst_prune __P ((Bstree *bst, Bst_prune_f pruner, void *prune_args, void *cmp_args));

/* Selectors */
Bstnode *bst_smallest __P ((const Bstree *bst));
Bstnode *bst_largest __P ((const Bstree *bst));

__END_DECLS


#endif /* ! LIBRETTO__BSTREE_HEADER_SEEN */
