/* libretto/autostr.h -- public header for libretto's autostr functions
 *
 * Aaron Crane <aaronc@pobox.com>
 * 12 April 1998
 *
 * This file is part of Libretto, a library of useful functions.
 * Libretto is Copyright  1996, 1997, 1998 Aaron Crane <aaronc@pobox.com>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBRETTO__AUTOSTR_HEADER_SEEN
#define LIBRETTO__AUTOSTR_HEADER_SEEN

#ifndef LIBRETTO__MAIN_HEADER_SEEN
#include <libretto/libretto.h>
#endif

__BEGIN_DECLS

/* Structors */
Autostr *astr_create __P ((void));
Autostr *astr_create_s __P ((const char *s));
void astr_destroy __P ((Autostr *str));
void astr_destroy_all __P ((Autostr *str, ...));

/* Status */
ssize_t astr_length __P ((const Autostr *str));
const char *astr_chars __P ((const Autostr *str));
int astr_valid_p __P ((const Autostr *str));

/* Copying */
int astr_copy __P ((Autostr *dest, const Autostr *src));
int astr_copy_s __P ((Autostr *str, const char *s));
int astr_copy_c __P ((Autostr *str, int c));
int astr_copy_from_abuf __P ((Autostr *str, const Autobuf *abuf));

/* Concatenation */
int astr_cat_c __P ((Autostr *str, int c));
int astr_cat_s __P ((Autostr *str, const char *s));
int astr_cat __P ((Autostr *dest, const Autostr *src));

/* Insertion */
int astr_insert_c __P ((Autostr *str, ssize_t index, int c));
int astr_insert_s __P ((Autostr *str, ssize_t index, const char *s));
int astr_insert __P ((Autostr *dest, ssize_t index, const Autostr *src));

/* Deletion */
void astr_zero __P ((Autostr *str));
void astr_delete __P ((Autostr *str, ssize_t index, ssize_t n));

/* Case fiddling */
void astr_upcase __P ((Autostr *str));
void astr_downcase __P ((Autostr *str));
void astr_flipcase __P ((Autostr *str));
void astr_capitalise __P ((Autostr *str));
void astr_upcase_initials __P ((Autostr *str));

/* Search */
ssize_t astr_find __P ((const Autostr *astr, ssize_t index, const Autostr *target));
ssize_t astr_find_c __P ((const Autostr *astr, ssize_t index, int c));
ssize_t astr_find_s __P ((const Autostr *astr, ssize_t index, const char *s));
ssize_t astr_rfind_c __P ((const Autostr *astr, ssize_t last_found_index, int c));

ssize_t astr_find_match __P ((const Autostr *astr, ssize_t index, const Autostr *set));
ssize_t astr_find_match_s __P ((const Autostr *astr, ssize_t index, const char *set));
ssize_t astr_find_match_f __P ((const Autostr *astr, ssize_t index, Astr_istype_f func));
ssize_t astr_find_nmatch __P ((const Autostr *astr, ssize_t index, const Autostr *set));
ssize_t astr_find_nmatch_s __P ((const Autostr *astr, ssize_t index, const char *set));
ssize_t astr_find_nmatch_f __P ((const Autostr *astr, ssize_t index, Astr_istype_f func));

/* Comparison */
int astr_null __P ((const Autostr *astr));
int astr_equal __P ((const Autostr *a, const Autostr *b));
int astr_equal_s __P ((const Autostr *astr, const char *s));
int astr_iequal __P ((const Autostr *a, const Autostr *b));
int astr_iequal_s __P ((const Autostr *astr, const char *s));
int astr_cmp __P ((const Autostr *a, const Autostr *b));
int astr_cmp_s __P ((const Autostr *astr, const char *s));
int astr_icmp __P ((const Autostr *a, const Autostr *b));
int astr_icmp_s __P ((const Autostr *astr, const char *s));

/* Substring */
int astr_slice __P ((Autostr *dest, const Autostr *src, ssize_t index, ssize_t n));
int astr_slice_i __P ((Autostr *dest, const Autostr *src, ssize_t start, ssize_t end));

/* Transliteration */
void astr_translit __P ((Autostr *str, const Autostr *fromset, const Autostr *toset));
void astr_translit_c __P ((Autostr *str, int from, int to));
void astr_translit_s __P ((Autostr *str, const char *fromset, const char *toset));
void astr_translit_f __P ((Autostr *str, Astr_istype_f from, Astr_totype_f to));
/* Note that this is valid: `astr_translit_f (astr, isxdigit, toupper);' */

/* Input/Output */
ssize_t astr_getline __P ((Autostr *str, FILE *file));
ssize_t astr_getdelim __P ((Autostr *str, FILE *file, int delim));

/* C-like escape-sequence characters */
int astr_esc_char __P ((const Autostr *str, ssize_t *offset));
int astr_esc_char_c __P ((const Autostr *str, ssize_t *offset, int c));

__END_DECLS


#endif /* ! LIBRETTO__AUTOSTR_HEADER_SEEN */
