/* libretto/autobuf.h -- public header for libretto's autobuf functions
 *
 * Aaron Crane <aaronc@pobox.com>
 * 12 April 1998
 *
 * This file is part of Libretto, a library of useful functions.
 * Libretto is Copyright  1996, 1997, 1998 Aaron Crane <aaronc@pobox.com>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBRETTO__AUTOBUF_HEADER_SEEN
#define LIBRETTO__AUTOBUF_HEADER_SEEN

#ifndef LIBRETTO__MAIN_HEADER_SEEN
#include <libretto/libretto.h>
#endif


__BEGIN_DECLS

/* Structors */
Autobuf *abuf_create __P ((void));
void abuf_destroy __P ((Autobuf *abuf));

/* Status */
unsigned char *abuf_data __P ((const Autobuf *abuf));
ssize_t abuf_length __P ((const Autobuf *abuf));
int abuf_valid_p __P ((const Autobuf *abuf));

/* Copying */
int abuf_copy __P ((Autobuf *dest, const Autobuf *src));
int abuf_copy_buf __P ((Autobuf *dest, const unsigned char *buf, ssize_t len));
int abuf_copy_astr __P ((Autobuf *abuf, const Autostr *str));
int abuf_copy_s __P ((Autobuf *abuf, const char *s));
int abuf_copy_c __P ((Autobuf *abuf, int c));

/* Concatenation */
int abuf_cat __P ((Autobuf *dest, const Autobuf *src));
int abuf_cat_buf __P ((Autobuf *dest, const unsigned char *buf, ssize_t len));
int abuf_cat_astr __P ((Autobuf *abuf, const Autostr *str));
int abuf_cat_s __P ((Autobuf *abuf, const char *s));
int abuf_cat_c __P ((Autobuf *abuf, int c));

/* Insertion */
int abuf_insert __P ((Autobuf *dest, ssize_t index, const Autobuf *src));
int abuf_insert_buf __P ((Autobuf *dest, ssize_t index,
			 const unsigned char *buf, ssize_t len));
int abuf_insert_astr __P ((Autobuf *abuf, ssize_t index, const Autostr *str));
int abuf_insert_s __P ((Autobuf *abuf, ssize_t index, const char *s));
int abuf_insert_c __P ((Autobuf *abuf, ssize_t index, int c));

/* Memset */
int abuf_set __P ((Autobuf *abuf, ssize_t n, int c));

/* Deletion */
void abuf_zero __P ((Autobuf *abuf));
void abuf_delete __P ((Autobuf *abuf, ssize_t index, ssize_t n));

/* Search */
ssize_t abuf_find __P ((const Autobuf *abuf, ssize_t index, const Autobuf *target));
ssize_t abuf_find_buf __P ((const Autobuf *abuf, ssize_t index,
			    const unsigned char *buf, ssize_t len));
ssize_t abuf_find_astr __P ((const Autobuf *abuf, ssize_t index, const Autostr *str));
ssize_t abuf_find_s __P ((const Autobuf *abuf, ssize_t index, const char *s));
ssize_t abuf_find_c __P ((const Autobuf *abuf, ssize_t index, int c));

ssize_t abuf_rfind_c __P ((const Autobuf *abuf, ssize_t last_found_index, int c));

/* Comparison */
int abuf_equal __P ((const Autobuf *x, const Autobuf *y));
int abuf_cmp __P ((const Autobuf *x, const Autobuf *y));

/* `Substring' */
int abuf_slice __P ((Autobuf *dest, const Autobuf *src, ssize_t index, ssize_t n));
int abuf_slice_i __P ((Autobuf *dest, const Autobuf *src, ssize_t start, ssize_t end));

/* Input/Output */
ssize_t abuf_fread __P ((Autobuf *abuf, FILE *file, ssize_t n));
ssize_t abuf_fwrite __P ((const Autobuf *abuf, FILE *file, ssize_t index, ssize_t n));
ssize_t abuf_getdelim __P ((Autobuf *abuf, FILE *file, int delim));

__END_DECLS


#endif /* ! LIBRETTO__AUTOBUF_HEADER_SEEN */
