/* fmt-scan-priv.h -- header for formatting and scanning functions in Libretto
 *
 * Aaron Crane <aaronc@pobox.com>
 * 26 February 1998
 *
 * This file is part of Libretto, a library of useful functions.
 * Libretto is Copyright  1996, 1997, 1998 Aaron Crane <aaronc@pobox.com>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* These functions are built from scan.c.in and file.iif, str.iif and
 * stringt.iif respectively. */
int libretto__vfscanf (FILE *f, const char *fmt, va_list va)
    __attribute__ ((__format__ (__scanf__, 2, 0)));
int libretto__vsscanf (const char *src, const char *fmt, va_list va)
    __attribute__ ((__format__ (__scanf__, 2, 0)));
int libretto__vstrscanf (const Autostr *src, const char *fmt, va_list va)
    __attribute__ ((__format__ (__scanf__, 2, 0)));

/* This one is in vasnprintf.c */
ssize_t libretto__vasnprintf (char **as, ssize_t *asz, const char *fmt, va_list va)
    __attribute__ ((__format__ (__printf__, 3, 0)));

/* This one is in fmt-scan.c */
ssize_t libretto__vfprintf (FILE *f, const char *fmt, va_list va)
    __attribute__ ((__format__ (__printf__, 2, 0)));
