/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef TYPES_H
#define TYPES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assuan.h>
#include <libpwmd.h>

#ifdef WITH_TCP
#include <libssh2.h>
#ifndef DNS_USE_GETTIMEOFDAY_FOR_ID
#define DNS_USE_GETTIMEOFDAY_FOR_ID 1
#endif
#include <ares.h>
#include <arpa/nameser.h>
#endif

#ifdef WITH_LIBPTH
#include <pth.h>
#endif

#ifdef ENABLE_NLS
#ifdef HAVE_SETLOCALE
#include <locale.h>
#endif
#include "gettext.h"
#define N_(msgid)	dgettext("libpwmd", msgid)
#endif

#define N_ARRAY(a)	(sizeof(a)/sizeof(a[0]))

typedef enum {
    ASYNC_CMD_NONE,
#ifdef WITH_TCP
    ASYNC_CMD_DNS,
    ASYNC_CMD_CONNECT,
    ASYNC_CMD_HOSTKEY,
#endif
    ASYNC_CMD_OPEN,
    ASYNC_CMD_OPEN2,
    ASYNC_CMD_SAVE,
    ASYNC_CMD_SAVE2,
} pwmd_async_cmd_t;

#ifdef WITH_TCP
typedef enum {
    SSH_RESUME = -1,
    SSH_NONE,
    SSH_INIT,
    SSH_AUTHLIST,
    SSH_AUTH,
    SSH_AGENT,
    SSH_CHANNEL,
    SSH_SHELL
} pwmd_ssh_async_t;

typedef struct {
    char *host;
    unsigned port;
    char *username;
    char *known_hosts;
    char *identity;
    char *identity_pub;
    int fd;
    gpg_error_t rc;
    ares_channel chan;
    int async;
    struct in_addr addr;
    int addrtype;
    LIBSSH2_SESSION *session;
    LIBSSH2_CHANNEL *channel;
    LIBSSH2_KNOWNHOSTS *kh;
    LIBSSH2_AGENT *agent;
    struct libssh2_agent_publickey *agent_identity;
    struct libssh2_agent_publickey *agent_identity_prev;
    struct libssh2_knownhost *hostent;
    struct libssh2_knownhost *hostent_ip;
    char *hostkey;
    pwmd_async_cmd_t cmd;
    pwmd_ssh_async_t state;
} pwmd_tcp_conn_t;
#endif

#define OPT_LOCK_ON_OPEN	0x01
#define OPT_BASE64		0x02

struct pwm_s {
    assuan_context_t ctx;
#ifdef WITH_TCP
    pwmd_tcp_conn_t *tcp_conn;
    pwmd_ip_version_t prot;
    pwmd_knownhost_cb_t kh_cb;
    void *kh_data;
    int use_agent;
#endif
    int fd;
    pwmd_async_t state;
    pwmd_async_cmd_t cmd;
    pwmd_async_cmd_t lastcmd;
    char *result;	// not related to anything the client can see.
#ifdef WITH_PINENTRY
    pid_t pid;		// for pinentry timeouts when used with ..async2().
    assuan_context_t pctx;
    int nb_fd;		// for pwmd_open/save_async2().
    pid_t nb_pid;
    char *_password;
#endif
    int pinentry_tries;
    int pin_try;
    char *pinentry_path;
    char *pinentry_tty;
    char *pinentry_term;
    char *pinentry_display;
    char *lcctype;
    char *lcmessages;
    char *title;
    char *prompt;
    char *desc;
    char *password;
    char *filename;
    int pinentry_timeout;
    pwmd_passphrase_cb_t passfunc;
    void *passdata;
    pwmd_status_cb_t status_func;
    void *status_data;
    pwmd_inquire_cb_t inquire_func;
    void *inquire_data;
    size_t inquire_total;
    size_t inquire_sent;
#ifdef WITH_QUALITY
    int (*_inquire_func)(void *, const char *);
    void *_inquire_data;
#endif
    char *name;
    char *cipher;
    long iterations;
    unsigned opts;
};

typedef struct {
    size_t len;
    void *buf;
} membuf_t;

typedef struct {
    int fd;
    gpg_error_t error;
    char password[ASSUAN_LINELENGTH+1];
} pwmd_nb_status_t;

gpg_error_t _assuan_command(pwm_t *pwm, assuan_context_t ctx,
	char **result, const char *cmd);
gpg_error_t _connect_finalize(pwm_t *pwm);

#endif
