/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef SSH_H
#define SSH_H

void _free_ssh_conn(pwmd_tcp_conn_t *conn);
gpg_error_t _do_pwmd_ssh_connect_async(pwm_t *pwm, const char *host,
	int port, const char *identity, const char *user,
	const char *known_hosts, pwmd_async_cmd_t which);
gpg_error_t _setup_ssh_session(pwm_t *pwm);
gpg_error_t _do_pwmd_ssh_connect(pwm_t *pwm, const char *host, int port,
	const char *identity, const char *user, const char *known_hosts,
	int get);
gpg_error_t _parse_ssh_url(char *str, char **host, int *port, char **user,
	char **identity, char **known_hosts);
void _ssh_disconnect(pwm_t *pwm);
gpg_error_t _setup_ssh_init(pwm_t *pwm);
gpg_error_t _setup_ssh_authlist(pwm_t *pwm);
gpg_error_t _setup_ssh_auth(pwm_t *pwm);
gpg_error_t _setup_ssh_channel(pwm_t *pwm);
gpg_error_t _setup_ssh_shell(pwm_t *pwm);
gpg_error_t _setup_ssh_agent(pwm_t *pwm);
ssize_t write_hook_ssh(pwm_t *, assuan_fd_t fd, const void *data, size_t len);
ssize_t read_hook_ssh(pwm_t *, assuan_fd_t fd, void *data, size_t len);

#endif
