/*
                               TIME.C

                        Date & time functions
                    
                   Copyright (C) Laszlo Menczel, 2005
                         menczel@invitel.hu

        This is free software without warranty. See 'licence.txt'.
*/

#include <stdio.h>
#include <time.h>

#include "mutil.h"
#include "mutlib.h"

//==========================================================================

static char *month_name[] =
{
  "Jan", "Feb", "March", "April", "May", "June",
  "July", "Aug", "Sep", "Oct",  "Nov", "Dec"
};

//==========================================================================

int mut_get_date(char *buf)
{
  time_t tim;
  struct tm *tm_s;
  
  if (buf == NULL)
    MUTERR(MUTERR_BAD_ARG)

  time(&tim);
  tm_s = localtime(&tim);
  
  sprintf
  (
    buf, "%s %d %d %d:%02d:%02d",
    month_name[tm_s->tm_mon], tm_s->tm_mday, tm_s->tm_year + 1900,
    tm_s->tm_hour, tm_s->tm_min, tm_s->tm_sec
  );
  
  RETURN(1)
}
  
//==========================================================================

int mut_get_date_short(char *buf)
{
  time_t tim;
  struct tm *tm_s;
  
  if (buf == NULL)
    MUTERR(MUTERR_BAD_ARG)

  time(&tim);
  tm_s = localtime(&tim);
  
  sprintf
  (
    buf, "%d/%d/%d %d:%02d:%02d",
    tm_s->tm_mon + 1, tm_s->tm_mday, tm_s->tm_year + 1900,
    tm_s->tm_hour, tm_s->tm_min, tm_s->tm_sec
  );
  
  RETURN(1)
}
  
//==========================================================================

int mut_get_time(char *buf)
{
  time_t tim;
  struct tm *tm_s;
  
  if (buf == NULL)
    MUTERR(MUTERR_BAD_ARG)

  time(&tim);
  tm_s = localtime(&tim);
  
  sprintf
  (
    buf, "%d:%02d:%02d",
    tm_s->tm_hour, tm_s->tm_min, tm_s->tm_sec
  );
  
  RETURN(1)
}

//==========================================================================

int mut_make_time_stamp(char *buf)
{
  time_t tim;
  struct tm *tm_s;
  
  if (buf == NULL)
    MUTERR(MUTERR_BAD_ARG)

  time(&tim);
  tm_s = localtime(&tim);
  
  sprintf
  (
    buf, "%d-%d-%d-%dh%dm",
    tm_s->tm_year + 1900, tm_s->tm_mon + 1, tm_s->tm_mday,
    tm_s->tm_hour, tm_s->tm_min
  );
  
  RETURN(1)
}
