/*
                              PROCESS.C
                        
              Function for process creation under Win32
   
                  Copyright (C) Laszlo Menczel, 2006
                          menczel@invitel.hu

       This is free software without warranty. See 'licence.txt'.
*/

#if defined _WIN32

#include <windows.h>
#include "mutil.h"
#include "mutlib.h"

int mut_exec_prog(char *prog, int wait, int *retval, char *outfile)
{
  int res;
  DWORD proc_ret;
  BOOL inherit_handles;
  STARTUPINFO s_info;
  PROCESS_INFORMATION p_info;
  SECURITY_ATTRIBUTES secur;
  
  if (prog == NULL || (outfile != NULL && wait != -1))
    MUTERR(MUTERR_BAD_ARG)
  
  GetStartupInfo(&s_info);   // initialize stdin and stderr handles in s_info

  if (outfile == NULL)
  {
    inherit_handles = FALSE;
    s_info.dwFlags = 0;
  }
  else
  {
    inherit_handles = TRUE;

    secur.lpSecurityDescriptor = NULL;
    secur.bInheritHandle = TRUE;
    secur.nLength = sizeof(SECURITY_ATTRIBUTES);

    s_info.dwFlags = STARTF_USESTDHANDLES;
    s_info.hStdOutput =
      CreateFile
      (
        outfile,
        GENERIC_WRITE,
        0,
        &secur,
        CREATE_ALWAYS,
        FILE_ATTRIBUTE_NORMAL,
        NULL
      );

    if (s_info.hStdOutput == INVALID_HANDLE_VALUE)
      MUTERR(MUTERR_FILE)
  }
  
  s_info.lpReserved = NULL;  
  s_info.lpDesktop = NULL;  
  s_info.lpTitle = NULL;  
  s_info.dwX = s_info.dwY = s_info.dwXSize = s_info.dwYSize = 0;
  s_info.dwXCountChars = s_info.dwYCountChars = 0;
  s_info.dwFillAttribute = 0;
  s_info.wShowWindow = 0;
  s_info.cbReserved2 = 0;
  s_info.lpReserved2 = NULL;
  s_info.cb = sizeof(s_info);
  
  res = CreateProcess
        (
          NULL,
          prog,
          NULL,
          NULL,
          inherit_handles,
          CREATE_NEW_CONSOLE,
          NULL,
          NULL,
          &s_info,
          &p_info
        );
  
  if (res == 0)
    MUTERR(MUTERR_WIN32PROC)
  
  if (! wait)
  {
    *retval = 0;
    RETURN(1);
  }
  
  if (wait == -1)
    wait = INFINITE;
    
  res = WaitForSingleObject(p_info.hProcess, wait);

  switch (res)
  {
    case WAIT_FAILED:
      MUTERR(MUTERR_WIN32WAIT)
    
    case WAIT_TIMEOUT:
      MUTERR(MUTERR_TIMEOUT)
          
    case WAIT_OBJECT_0:
      if (retval != NULL)
      {
        res = GetExitCodeProcess(p_info.hProcess, &proc_ret);
        if (res == 0)
          MUTERR(MUTERR_WIN32EXITCODE)
        else
          *retval = proc_ret;
      }

      RETURN(1)

    default:
      MUTERR(MUTERR_UNDEF)
  }

  /* NEVER REACHED */
  return 0;            /* Be happy, stupid compiler! */
}

#endif  /* _WIN32 */
