#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>

#include "mutil.h"

static flist_t *list = NULL;

static void do_pause(void)
{
  printf("Press ENTER...\n");
  getchar();
}

int main(int argc, char *argv[])
{
  flist_t *curr;
  char *cp;
  
  if (argc > 1)
  {
    if (strcmp(argv[1], "-r") == 0)
      list = mut_glob_dir(NULL, NULL, MUT_FLIST_RECURS);
    else
    {
      printf("Bad argument.\n");
      do_pause();
      return 1;
    }
  }
  else
    list = mut_glob_dir(NULL, NULL, MUT_FLIST_SIMPLE);

  if (list == NULL)
  {
    printf("mut_glob_dir() failed.\n");
    do_pause();
    return 1;
  }
  
  cp = mut_glob_format(list, '\n', MUT_FLIST_ALL);

  if (cp == NULL)
    printf("mut_glob_format() failed.\n");
  else
    printf("%s\n", cp);

  do_pause();
  mut_glob_discard(&list);
  return 0;
}
