/*
                              ERROR.C

                           Error messages

                    Written by Laszlo Menczel, 2005
                         menczel@invitel.hu

        This is free software without warranty. See 'licence.txt'.
*/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "mutil.h"
#include "mutlib.h"

int __mut_errcode = NO_ERROR;

//=============================================================================

static char *bad_error = "unknown error";

static char *error_message[MUT_LAST_ERROR + 1] =
{
  "no error",

  /* general error types (1 to 49) */
  "bad function argument",
  "memory allocation failed",
  "file open error",
  "file type incorrect",
  "error when reading file",
  "error when writing file",
  "too many items",
  "not enough items",
  "bad token",
  "range error",				/* 10 */
  "no data (empty)",
  "type error",
  "size error",
  "unexpected end of string",
  "operation timeout",
  "cannot load the DLL specified",
  "object not found",
  "the device is not ready or not initialized",
  "directory not found",
  "cannot obtain requested system information",	/* 20 */
  "buffer overflow",
  "only part of the object was retrieved",
  "end of file reached",
  "WinAPI error: process creation failed",
  "WinAPI error: cannot wait on specified object",
  "WinAPI error: cannot get process exit code",
  "cannot access file",
  "cannot access directory",
  "system call failed",
  "resource is used by other process",		/* 30 */
  "file or directory is read-only",

  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,			/* 40 */
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  
  /* errors in string-number conversion */

  "bad integer (not a number?)",		/* 50 */
  "bad float (not a number?)",
  "invalid base for integer value",
  "too many digits",
  "no digits",
  "not a digit",
  "extra characters in numeric string",
  "exponent out of range",
  "no exponent value specified",
  "bad exponent value",
  "too many decimal points",			/* 60 */

  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,

  /* errors in config file loading */

  "cannot open/read config file",		/* 70 */
  "parameter name NULL or empty",
  "invalid parameter type",
  "pointer to parameter target variable is NULL",
  "size of specified string buffer < 1",
  "bad parameter index",
  "no value specified for a parameter",
  "error when converting numeric parameter",
  "at least one parameter is not loaded",

  NULL,
  NULL,			/* 80 */
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,

  /* errors in command line parsing */

  "program name is too long to store",		/* 90 */
  "argument string too long",
  "argument not recognized",
  "paired argument has no value",
  "value string too long",
  "invalid characters in a value",
  "duplicate argument",
  "at least one required argument missing",

  NULL,
  NULL,
  NULL,			/* 100 */
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL
};  

//=============================================================================
// Public functions
//=============================================================================

int mut_last_error(void)
{
 return  __mut_errcode;
}

//=============================================================================

char *mut_errmsg(int code)
{
  if (code < 0 || code > MUT_LAST_ERROR || error_message[code] == NULL)
    return bad_error;

  return error_message[code];
}
