/*
 *  libmodem library, a modem control facility.
 *
 *  termios_cc.h - various termios definitions, private
 *
 *  Copyright (C) 1994,1995,1996,1997,1998,1999  Riccardo Facchetti
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  You can contact the author at this e-mail address:
 *
 *  fizban@tin.it
 */

/*
 * avoid multiple inclusion
 */
#ifndef _ML_TERMIOS_CC_H
#define _ML_TERMIOS_CC_H 1

#if    !defined(VSWTCH) && defined(VSWTC)
#define    VSWTCH    VSWTC
#endif

#ifndef _POSIX_VDISABLE
#define _POSIX_VDISABLE '\377'
#endif

/* default control chars */
#ifndef CESC
#define    CESC    '\\'
#endif
#ifndef CINTR
#define    CINTR    0177    /* DEL */
#endif
#ifndef CQUIT
#define    CQUIT    034    /* FS, cntl | */
#endif
#ifndef CERASE
#define    CERASE    '\b'    /* BS, nonstandard */
#endif
#ifndef CKILL
#define    CKILL    '\025'    /* NAK, nonstandard */
#endif
#ifndef CEOF
#define    CEOF    04    /* cntl d */
#endif
#ifndef CSTART
#define    CSTART    021    /* cntl q */
#endif
#ifndef CSTOP
#define    CSTOP    023    /* cntl s */
#endif
#ifndef CEOL
#define    CEOL    000    /* cntl j */
#endif

#ifdef CSWTCH
# undef CSWTCH        /* usually ^z, unwanted here */
#endif
#define CSWTCH    000    /* <undef> */

#ifndef CSUSP
# ifdef SVR42
#  define CSUSP 026    /* cntl z */
# else
#  define CSUSP _POSIX_VDISABLE        /* have only job control aware */
                                       /* shells use it */
# endif
#endif

#endif /* _ML_TERMIOS_CC_H */
