/*
 *  libmodem library, a modem control facility.
 *
 *  mdmlock.c - modem lock files
 *
 *  Copyright (C) 1994,1995,1996,1997,1998,1999  Riccardo Facchetti
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  You can contact the author at this e-mail address:
 *
 *  fizban@tin.it
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <syslog.h>

#include <dial/modems.h>

#define BUFSIZE		128

/*
 * Signal to check if a PID exist
 */
#define SIGPIDEXIST	0

char *__mdmlock = "mdmlock.c (C) Riccardo Facchetti, version " LIBMODEM_VER;

int mdm_lock(struct modems *device) {
    int fd;
    int lpid;
    char *buffer;
    char *buffer1;

    buffer = mdmalloc(BUFSIZE);

    if (!buffer)
	    return (mdmerrno = -EMDMEM);

    buffer1 = mdmalloc(BUFSIZE);

    if (!buffer1) {
	    mdmfree(buffer);
	    return (mdmerrno = -EMDMEM);
    }

/*
 * build the lockfile pathname
 */
    sprintf(buffer, "%s/LCK..%s", LOCKDIR, device->line);

/*
 * check if the lock directory exist
 */
    if (access(LOCKDIR, R_OK|W_OK|X_OK) == -1)
	    return (mdmerrno = -EMDMNOLKDIR);

/*
 * check if line is alredy locked
 */
reopen_lock:
    if ((fd = open(buffer, O_CREAT|O_WRONLY|O_EXCL)) == -1) {
/*
 * the lock exist. Get the pid and check if the process lpid exist.
 * If not, remove the stale lock
 */
        fd = open (buffer, O_RDONLY);
        if (read(fd, buffer1, BUFSIZE) > 0) {
        	sscanf(buffer1, "%10d", &lpid);
        	if (kill(lpid, SIGPIDEXIST) == 0) {
			mdmfree(buffer);
			mdmfree(buffer1);
        		return (mdmerrno = -EMDMLOCK);
		}
	}
        close(fd);

        unlink(buffer);
        goto reopen_lock;
    }

    fchmod(fd, 0644);
/*
 * lock the line
 */
    sprintf(buffer, "%10d\n", getpid());
    if (write(fd, buffer, strlen(buffer)) != strlen(buffer)) {
	    mdm_log(LOG_ERR, "Error writing modem lock file\n");
    	    close(fd);
            unlink(buffer);
	    mdmfree(buffer);
	    mdmfree(buffer1);
	    return (mdmerrno = -EMDMLOCK);
    }
    close(fd);
    mdmfree(buffer);
    mdmfree(buffer1);
    return (mdmerrno = -ENOMDMERR);
}

int mdm_unlock(struct modems *device) {
	char *buffer;

	buffer = mdmalloc(BUFSIZE);

	if (!buffer)
		return FAILURE;

/*
 * build the lockfile pathname
 */
    sprintf(buffer, "%s/LCK..%s", LOCKDIR, device->line);
    
    if (unlink(buffer) == -1) {
	    mdmfree(buffer);
        return FAILURE;
    }
    mdmfree(buffer);
    return SUCCESS;
}

int mdm_chklock(struct modems *device) {
    int fd;
    int lpid;
	char *buffer;
	char *buffer1;

	buffer = mdmalloc(BUFSIZE);

	if (!buffer)
		return FAILURE;

	buffer1 = mdmalloc(BUFSIZE);

	if (!buffer1) {
		mdmfree(buffer);
		return FAILURE;
	}

/*
 * build the lockfile pathname
 */
    sprintf(buffer, "%s/LCK..%s", LOCKDIR, device->line);
    
    if (access(buffer, F_OK) == -1) {
	    mdmfree(buffer);
	    mdmfree(buffer1);
        return FAILURE;
    }

/*
 * the lock exist. Get the pid and check if the process lpid exist.
 * If not, remove the stale lock
 */
    fd = open (buffer, O_RDONLY);
    if (read(fd, buffer1, BUFSIZE) > 0) {
    	sscanf(buffer1, "%10d", &lpid);
    	if (kill(lpid, SIGPIDEXIST) == 0) {
		mdmfree(buffer);
		mdmfree(buffer1);
        	return SUCCESS;
	}
    }
    close(fd);
    unlink(buffer);
    mdmfree(buffer);
    mdmfree(buffer1);
    return FAILURE;
}
