/*
 *  libmodem library, a modem control facility.
 *
 *  mdmerrno.c - error status of libmodem package
 *
 *  Copyright (C) 1994,1995,1996,1997,1998,1999  Riccardo Facchetti
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  You can contact the author at this e-mail address:
 *
 *  fizban@tin.it
 */

#include <stdio.h>

#include <dial/modems.h>

char *__mdmerrno = "mdmerrno.c (C) Riccardo Facchetti, version " LIBMODEM_VER;

int mdmerrno = 0;

char *_mdm_sys_errlist[] = {
"No error.",
"Unknown error.",
"No modems config file.",
"Error in config file.",
"Specified modem line not in config file.",
"Can't lock this line, alredy locked.",
"Can't open this line.",
"Can't get line attributes.",
"Can't set line attributes.",
"Baud rate not permitted.",
"Can't write to modem.",
"Error in select().",
"Can't read from modem.",
"Can't sync with modem reply.",
"Busy.",
"No carrier.",
"No modem with required capablity available.",
"Modem returned ERROR.",
"Can't stat serial device.",
"Line is not a character device.",
"Bad minor device number.",
"Bad major device number.",
"Bad file descriptor.",
"FD was not set when select returned (timeout).",
"Modem stalled.",
"Ringing (incoming call).",
"No dialtone.",
"No answer.",
"Malloc failed: no memory.",
"Line lock failed: can't access lock directory.",
"No carrier.",
"Ringing (outgoing call).",
NULL
};

char *mdmstrerror(int merr) {
    merr = (merr <= 0 ? -merr : EUNMDMERR);
    return (_mdm_sys_errlist[merr]);
}

void mdmperror(char *msg) {
    int merr = (mdmerrno <= 0 ? -mdmerrno : EUNMDMERR);
    fprintf(stderr, "%s: %s\n", msg, _mdm_sys_errlist[merr]);
}
