/*
 *  libmodem library, a modem control facility.
 *
 *  mdmalloc.c - memory allocation routines
 *
 *  Copyright (C) 1994,1995,1996,1997,1998,1999  Riccardo Facchetti
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  You can contact the author at this e-mail address:
 *
 *  fizban@tin.it
 */
#include <stdlib.h>
#include <memory.h>
#include <dial/mdmerrno.h>

void *mdmalloc(size_t size) {
	void *ptr;

	ptr = malloc(size);

	if (ptr)
		memset(ptr, 0, size);

	return ptr;
}

void mdmfree(void *ptr) {
	free(ptr);
}
