/*
 *  libmodem library, a modem control facility.
 *
 *  line_managePriv.h - private header file
 *
 *  Copyright (C) 1994,1995,1996,1997,1998,1999  Riccardo Facchetti
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  You can contact the author at this e-mail address:
 *
 *  fizban@tin.it
 */

/*
 * avoid multiple inclusions
 */
#ifndef _LM_LINE_MANAGEPRIV_H
#define _LM_LINE_MANAGEPRIV_H 1

#define READ_RTRY   1024 /* we read a char at a time */
#define MODEM_RETURN    '\r'

struct mdm_reply_s {
	char *	r_str;
	int	r_err;
};

/* line_manage.c */
static int talk_to_modem(int, struct modems *, char *);
static void alarm_jump(int);
static int dial_to_num(int, struct modems *, char *);
static int initialize_modem(int, struct modems *);
static int open_modem_setup_line(struct modems *, int);
static struct mdm_reply_s * check_for_string(char *);
static int get_command(char *, char *);

#endif /* _LM_LINE_MANAGEPRIV_H */
