.\" -*- nroff -*-
.ds g \" empty
.ds G \" empty
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.de UR                          \" underline roman
\\$1\l'|0\(ul'\\$2
..
.de RUR                          \" roman underline roman
\\$1\\$2\l'-\w'\\$2'u\(ul'\\$3
..
.TH MODEMS 2 "13 Mar 1997"
.SH NAME
libmodem, dial, ldial, bdial, bldial, close_nohangup, hangup, modems, getmdmnam,
setmdms, setmdmdata, getnextmdm, mdm_lock, mdm_unlock, mdm_chklock,
_mdm_sys_errlist, mdmerrno, mdmstrerror, mdmperror, open_mdm_line, lopen_mdm_linelopen_mdm_line, bopen_mdm_line, blopen_mdm_line \- modem management package.
.SH SYNOPSIS
.nf
.B #include <dial/modems.h>
.SH DESCRIPTION
\fIlibmodem\fP is a library that allow you to use your modems transparently
with regard of kind of modem attached to a line. You have just to

int fd;
.br
fd = dial("Some-phone-number");

and it will return to you a file descriptor of the dialed line.
To hangup just hangup(fd).
Of course, you have to configure all your modem lines in the \fI/etc/modems\fP
file to allow the library know which modem lines it can use to dial.
Link the library with \fI-lmodem\fP.
.SH HEADER FILES

<dial/modems.h>
.br
<dial/mdmerrno.h> (included by dial/modems.h)

.SH STRUCTURES
.PP
.RS
.nf
struct modems {
	char	line[MAXNAMLEN];	/* line name (without /dev/) */
	char	cp[MAXMDMCMD];		/* command prefix */
	char	ce[MAXMDMCMD];		/* command end */
	char	at[MAXMDMCMD];		/* attention string */
	time_t	dl;		/* delay waiting answer from modem */
	int	bdi;			/* max baud rate (integer number) */
	int	bd;			/* max baud rate (termios translation) */
	char	cs[MAXMDMCMD];		/* connect string */
	char	ds[MAXMDMCMD];		/* dial string */
	char	dp[MAXMDMCMD];		/* dial prefix */
	char	de[MAXMDMCMD];		/* dial end */
	char	im[MAXMDMCMD];		/* initialize modem */
	char	hu[MAXMDMCMD];		/* hangup string */
	int	fc;			/* flow control */
/*
 * members not present in /etc/modems: filled at runtime.
 */
	int	connected;		/* 1 when connected, 0 otherwise */
	char	bits;			/* data bits (default '8') */
	char	parity;			/* parity (default 'N') */
	char	stop;			/* stop bits (default '1') */
};
.fi
.RE
.PP

.SH FUNCTIONS AND VARIABLES
/*
 *
 * extern declarations
 * (exported functions and variables from libmodem)
 */
.SH modems.c
In the file modems.c there are all the function related with the
modem devices database (/etc/modems).

********************************************************************
.br
*
.br
* #include <modems.h>
.br
*
.br
* extern struct modems *getmdmnam(char *device);

\fIdevice\fP is a string containing a modem device (without the prefix /dev/)

\fIRETURN VALUES\fP:
.br
a pointer to the modem description structure (NULL on error)
The storage of the structure returned is a static area that is rewritten
at every invocation of getmdmnam()

Eg.:

#include <modems.h>

struct modems *mdm;

mdm = getmdmnam("modem");

********************************************************************
.br
*
.br
* #include <modems.h>
.br
*
.br
* extern void setmdms(void);
.br
* extern struct modems *getnextmdm(void);
.br

This pair of functions allow you to navigate the \fI/etc/modems\fP file.

\fIsetmdms()\fP sets up the libmodem for navigation.

\fIRETURN VALUES\fP:
.br
\fIgetnextmdm()\fP return a pointer to the next modem
description in \fI/etc/modems\fP file, NULL on error or no more modems.

You can call \fIgetnextmdm()\fP more times to get one by one all the modems
configured in \fI/etc/modems\fP.
The storage of the structure returned is a static area that is rewritten
at every invocation of getnextmdm()

Eg:

#include <modems.h>

struct modems *mdm;

setmdms();

while ((mdm = getnextmdm()) != NULL) {
.br
	/* do something */
.br
}
********************************************************************
.br
*
.br
* #include <modems.h>
.br
*
.br
* extern void setmdmdata(char bits, char parity, char stop, int rings);

This function must be called just before calling dialing routines. It set up
the data/parity/stop infos for the callout. It sets also the maximum number
of rings we will wait for an outgoing call. This last functionality is active
only if we have a modem supporting the 'RINGING' response.
Possible values for parameters are:
.br
\fIbits\fP '5','6','7','8'
.br
\fIparity\fP 'E','O','N'
.br
\fIstop\fP '1','2'
.br
\fIrings\fP number of rings before stopping outgoing dialing.

\fIRETURN VALUES\fP:
.br
None.

Eg.:

#include <modems.h>

...
	setmdmdata('7', 'E', '1');
	dial("xxxxxxxx");
...

.SH line_manage.c
In line_manage.c are all the functions related to the work of modems.
dial a number, talk to modem, etc.

********************************************************************
.br
*
.br
* #include <modems.h>
.br
*
.br
* extern int dial(char *phone);
.br
* extern int ldial(char *phone, char *line);
.br
* extern int bdial(char *phone, int speed);
.br
* extern int bldial(char *phone, char *line, int speed);
.br
* extern int open_mdm_line();
.br
* extern int lopen_mdm_line(char *line);
.br
* extern int bopen_mdm_line(int speed);
.br
* extern int blopen_mdm_line(char *line, int speed);
.br
* extern int close_nohangup(int fd);
.br
* extern int hangup(int fd);
.br
* extern int clean_line(int fd, int waittime);
.br
* extern struct modems *mdmopendevice;
.br
* extern int mdm_cycle;

\fI(bl)dial()\fP are all functions that dial a phone number over a modem line.
\fIphone\fP is a string containing the phone number to be dialed.
It is mandatory if you want to dial something.
\fIline\fP is the modem line to be used for this dial. If you select the line,
the package tries to dial over that specified line.
\fIspeed\fP is the speed at which dial the number. If you do not specify the
speed, eg. you use the bdial() function, the package will select an unused line
that can support that speed.

\fI(bl)open_mdm_line()\fP follow the same convention as *dial functions.
The only difference is that there is no telephone number given.
The purpose of blopen_mdm_line() is just to open a line with the
modem/module (with all termioctl controls), send the init string
(from /etc/modems), and then return an open file descriptor. The
surrounding application can then send commands to the module (the
handling of those commands is not the responsibilty of the libmodem:
the application is just dealing with the file descriptor.


\fIRETURN VALUES\fP:
.br
\fI(bl)dial()\fP and \fI(bl)open_mdm_line()\fP return a file descriptor
over which you can read/write on the dialed (or opened) line. If returns < 0,
an error was encountered.

\fIclose_nohangup()\fP is the function that, given the fd returned by one of the
dial() functions, close the fd \fIwithout hanging up the modem line\fP. Be
warned: the modem line remains opened so the phone bill is going to grow. Don't
forget to hang up the line by some other way or you are going to be fired
by someone for the phone bill!

\fIhangup()\fP is the function that, given the fd returned by one of the dial()
functions, hangs up the communication between your modem and the remote one.

\fImdmopendevice\fP is a global variable that contain the modem device
description of the opened modem, if (bl)dial() returned a valid file descriptor.

\fImdm_cycle\fP is a global variable. Normally it is set to 0. When set to >0,
by the library user before a (b)dial(), and the (b)dial returned error, the
library cycle all the available modems until a valid file descriptor is
returned or the last modem in config file is tryed. Of course, if this
variable is set to >0 and no modems are returning a valid file descriptor after
a dial, the last error returned is -ENOMDMDEV. The library log all the single
modem errors to let the system administrator know that something is happening
to his/her modems. \fImdm_cycle\fP has the meanung "max number of times we
cycle", so if set to 3 the library will try to dial at most 3 modems searching
for a valid file descriptor (connection).

\fIRETURN VALUES\fP:
.br
\fIclose_nohangup()\fP and \fIhangup()\fP returns the last modem error
encountered.

Eg.:

#include <modems.h>

int fd;
.br
FILE *fp;

if ((fd = bdial("3246135", 19200)) < 0) {
.br
	mdmperror("error on dial");
.br
	exit(-1);
.br
}

fp = fdopen(fd, "r+");

fprintf(fp, "\\n\\nHello remote system.\\n");
.br
fprintf(fp, "Now i will hang up. See ya!\\n");

hangup(fd);

.SH mdmlock.c
This file contains all the functions related with locks of modem lines.

********************************************************************
.br
*
.br
* #include <modems.h>
.br
*
.br
* extern int mdm_lock(struct modems *mdm);
.br
* extern int mdm_unlock(struct modems *mdm);
.br
* extern int mdm_chklock(struct modems *mdm);

in every function \fImdm\fP is a modems structure of the device that is to be
locked/unlocked/checked for lock. \fImdm_lock()\fP and \fImdm_chklock()\fP
identify and remove stale locks.


\fIRETURN VALUES:\fP
.br
\fImdm_lock()\fP return SUCCESS on a successful lock, otherwise FAILURE
.br
\fImdm_unlock()\fP return SUCCESS on a successful unlock, otherwise FAILURE
.br
\fImdm_chklock()\fP return SUCCESS if the line is locked, otherwise FAILURE
.br

.SH mdmerrno.c
This file contains all the functions related with the error status of the
libmodem package.

********************************************************************
.br
*
.br
* #include <modems.h>
.br
*
.br
* extern char *_mdm_sys_errlist[];
.br
* extern int mdmerrno;
.br
*
.br
* extern char *mdmstrerror(int);
.br
* void mdmperror(char *);
.br

\fI_mdm_sys_errlist\fP is an array of strings that contain all the modem related
error messages. \fImdmerrno\fP is the actual error status of the package. It can
be used to reference the error messages in their array.
\fImdmstrerror()\fP and \fImdmperror()\fP works just like \fIstrerror()\fP
and \fIperror()\fP

.SH CONFIGURATION FILE

The \fI/etc/modems\fP is the only configuration file for the libmodem package.
You can also change the location of this file setting the environment variable
\fIMDMFILE\fP. If this variable is set, the modems description file will be
opened at \fI$MDMFILE\fP while if it is not set the default hard coded value
is still \fI/etc/modems\fP.
Every line of the file describe a modem device, described by a couple of fields.

# /etc/modems - example file
.br
#
.br
# This file contains all the modem informations. This is the list
.br
# of the system modems that will be used when callbacking, by the
.br
# libmodem
.br
#
.br
# Format:
.br
#
.br
# line:cp:ce:at:dl:bd:cs:ds:dp:de:im:hu:fc
.br
#
.br
# line: the modem device. If you have a /dev/modem, you will use
.br
#       only 'modem' without '/dev/' prefix
.br
# cp:	command prefix (usually AT)
.br
# ce:	command end (suffix)
.br
# at:	attention string (usually +++)
.br
# dl:	delay waiting for OK, in seconds (be warned that a +++ may require a
.br
#       long delay
.br
# bd:	max baud rate (every rate below this is allowed)
.br
# cs:	connect string (usually CONNECT)
.br
# ds:	dial string (usually DT for tone or DP for pulse), if null, cannot dial
.br
# dp:	dial prefix number (e.g. '0,')
.br
# de:	dial end
.br
# im:	initialize modem (usually H0V1Q0E1)
.br
# hu:	hangup string (usually H0)
.br
# fc:	flow control (0==Hardware RTS/CTS, 1==XON/XOFF)
.br
#
.br
# Note: ALL the above fields must be present in a modem entry. If set to
.br
#       nothing, like '::' it will be NULL, zero, nada, niente!

modem:AT::+++:30:14400:CONNECT:DT:::ZH0V1Q0E1:H0:0
.br
tty8:AT::+++:30:14400:CONNECT:DT:::ZH0V1Q0E1:H0:0

.SH LOCK FILES
Lock files are put in

\fI_LOCK_PATH_LCK..<line>\fP

where \fIline\fP is the device name (modem1, modem2, etc), and inside the file,
the pid of the process using the \fIfprintf(fp, "%10d", pid)\fP

.SH NOTES
libmodem is written for Linux, but i think you can easily port this package on
other platforms (that have \fIPOSIX_TERMIOS\fP of course :))
This is a production version of the code, developed as modem library for another
package. The library libmodem is distributed as a package, subjected to the
\fIGNU LIBRARY GENERAL PUBLIC LICENSE\fP
.SH BUGS
After some years of work on this library, I'm quite sure that it contains no
strange bugs, but I can not say it for sure, of course.
If you find one of them please let me know, e-mail me!
.SH AUTHORS
Riccardo Facchetti
.br
e-mail:		fizban@tin.it
.SH VERSION
_LIB_VERSION_
.SH COPYRIGHT
(C) 1994,1995,1996,1997,1998,1999 Riccardo Facchetti under the terms
of the GNU Library General Public Licence
