/*
 *  libmodem library, a modem control facility.
 *
 *  mdmerrno.h - #include <modems.h> that include this file too
 *
 *  Copyright (C) 1994,1995,1996,1997,1998,1999  Riccardo Facchetti
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  You can contact the author at this e-mail address:
 *
 *  fizban@tin.it
 */

/*
 * avoid multiple inclusions
 */

#ifndef _ML_MDMERRNO_H
#define _ML_MDMERRNO_H 1

#define ENOMDMERR	0    /* No error */
#define EUNMDMERR	1    /* Unknown error */
#define ENOMDMFILE	2    /* No modems config file */
#define EMDMBADCONF	3    /* Error in config file */
#define ENOMDMLINE	4    /* Specified modem line not in config file */
#define EMDMLOCK	5    /* Can't lock this line */
#define EMDMOPEN	6    /* Can't open this line */
#define EMDMGETA	7    /* Can't get line attributes */
#define EMDMSETA	8    /* Can't set line attributes */
#define EMDMBAUD	9    /* Baud rate not permitted */
#define EMDMWRITE	10   /* Can't write to modem */
#define EMDMSEL		11   /* Error in select() */
#define EMDMREAD	12   /* Can't read from modem */
#define EMDMSYNC	13   /* Can't sync with modem reply (obsolete) */
#define EMDMBUSY	14   /* Busy */
#define EMDMNOCAR	15   /* No carrier */
#define ENOMDMDEV	16   /* No modem with required capablity available */
#define EMDMERROR	17   /* Modem returned ERROR */
#define EMDMSTAT	18   /* Can't stat serial device */
#define EMDMNOCHR	19   /* Line is not a character device */
#define EMDMBADMIN	20   /* Bad minor device number */
#define EMDMBADMAJ	21   /* Bad major device number */
#define EMDMBADFD	22   /* Bad file descriptor */
#define EMDMNOFDSET	23   /* FD was not set when select returned (timeout) */
#define EMDMRDRT	24   /* Modem stalled */
#define EMDMRING	25   /* Ringing: incoming call */
#define EMDMTONE	26   /* No dialtone */
#define EMDMANSW	27   /* No answer */
#define EMDMEM		28   /* Malloc failed: no memory */
#define EMDMNOLKDIR	29   /* Line lock failed: can't access lock directory */
#define EMDMCARR	30   /* No carrier */
#define EMDMRINGING	31   /* Ringing: outgoing call */

#if !defined(__BEGIN_DECLS) && !defined(__END_DECLS)
/*
 * This is GNU libc macros for extern C functions: just in case.
 *
 * C++ needs to know that types and declarations are C, not C++.
 */
# ifdef  __cplusplus
#  define __BEGIN_DECLS  extern "C" {
#  define __END_DECLS    }
# else
#  define __BEGIN_DECLS
#  define __END_DECLS
# endif
#endif

__BEGIN_DECLS

/* extern variables in mdmerrno.c */
extern char *_mdm_sys_errlist[];
extern int mdmerrno;

/* functions exported by mdmerrno.c */
extern char *mdmstrerror(int);
extern void mdmperror(char *);

__END_DECLS

#endif /* _ML_MDMERRNO_H */
