/*
 *  libmodem library, a modem control facility.
 *
 *  call.c - test program
 *
 *  Copyright (C) 1994,1995,1996,1997,1998,1999  Riccardo Facchetti
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  You can contact the author at this e-mail address:
 *  
 *  fizban@tin.it
 */

/*
 * This program is a little dumb'n stupid callout program.
 * Set the phone number and modem line in the ldial() statement.
 *
 * To hangup just 'kill -TERM <pid>'
 */
#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <memory.h>
#include <dial/modems.h>

int fd;

void term(int sig) {
    hangup(fd);
    exit(0);
}

void main(int argc, char *argv[])
{
    char *buffer;
    fd_set rf;
    struct timeval to;
    int ret;

    ret = setreuid(0,0);
    buffer = malloc(1024);

    if (!buffer) {
	    printf("Not enought memory.\n");
	    exit(-1);
    }

    if (argc != 2) {
	    printf("Syntax: call <phone number>\n");
            exit(-1);
    }

    setmdmdata('8','N','1', 0);

    fd = dial(argv[1]);
    if (fd < 0) {
        mdmperror("ldial failed");
	free(buffer);
        exit(-1);
    }
    signal(SIGTERM, term);
    setbuf(stdout, NULL);
    setbuf(stdin, NULL);

    while(1) {
        FD_ZERO(&rf);
        FD_SET(fd, &rf);
        FD_SET(0, &rf);
        to.tv_sec = 0;
        to.tv_usec = 10;
        ret = select(FD_SETSIZE, &rf, NULL, NULL, &to);
        if (ret >=0) {
            if (FD_ISSET(fd, &rf)) {
                if (read(fd, buffer, 1024) > 0) {
                	printf(buffer);
		}
            }
            if (FD_ISSET(0, &rf)) {
                char *cp = buffer;
                int i=0;

                read(0, buffer, 1024);
                while(cp[i]) {
                    if (cp[i] == '\n')
                        cp[i] = '\r';
                    i++;
                }
                write(fd, buffer, strlen(buffer));
                tcdrain(fd);
            }
        }
        memset(buffer, 0, 1024);
    }
    free(buffer);
}
