/* testlst.c
 * compile: gcc -o testlst -s -Wall -llist testlst.c
 */

#include "list.h"
#include <stdio.h>
#include <stdlib.h>

typedef struct {
  link_t l;
  int bar;
} foo_t;

int find_fn(void *p1, void *data);

int main(int argc, char *argv[])
{
  list_t l;
  int i;
  foo_t *fptr;

  printf("Initializing listhead.\n");
  ls_init(&l);

  printf("Appending to list...");
  for (i=0; i<100; i++) {
    foo_t *pfoo = malloc(sizeof(foo_t));
    if (pfoo == 0) {
      printf("Allocation of foo_t structure failed. Abort\n");
      exit(1);
    }
    pfoo->bar = i;
    ls_append(&l, pfoo);
  }
  printf(" done\n");

  printf("Prepending to list...");
  for (i=0; i<100; i++) {
    foo_t *pfoo = malloc(sizeof(foo_t));
    if (pfoo == 0) {
      printf("Allocation of foo_t structure failed. Abort\n");
      exit(1);
    }
    pfoo->bar = -i;
    ls_prepend(&l, pfoo);
  }
  printf(" done\n");

  printf("Printing list values:\n");
  fptr = (foo_t*)ls_head(&l);
  while(fptr) {
    printf("pftr->bar = %d\n", fptr->bar);
    fptr = (foo_t*)ls_next(&l);
  }

  printf("Number of items in the list: %d\n", ls_count(&l));

  printf("Looking for number 45...\n");
  i = 45;
  fptr = ls_search(&l, find_fn, &i); 
  if (fptr)
    printf("Number 45 is in the list, at address %p\n", fptr);
  else
    printf("Number 45 is NOT in the list\n");

  printf("Emptying list...");
  ls_delete(&l);
  printf(" done\n");

  printf("Number of items in the list: %d\n", ls_count(&l));

  printf("End of program.\n\n");
  return 0;
}

int find_fn(void *p1, void *data)
{
  foo_t *pfoo = (foo_t *)p1;
  int n = *(int*)data;
  if (pfoo->bar == n)
    return 0; /* found it */
  return 1;
}
