/* $Id: ls_util.c,v 0.1 1997/08/21 08:40:13 rsmit06 Exp rsmit06 $
 *
 * This file contains the implementation of utility routines 
 * from the list library.
 *
 * Copyright (C) 1997  R.F. Smith
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: ls_util.c,v $
 * Revision 0.1  1997/08/21 08:40:13  rsmit06
 * Initial code.
 *
 */

#include "list.h"

/* look if pointer points to a link in the list */
int ls_find(list_t *ls, void *islink)
{
  void *ptr = ls_head(ls);

  while (ptr) {
    if (ptr == islink)
      return 1; /* yes */
    ptr = ls_next(ls);
  }
  return 0; /* no */
}

/* get the count of the number of elements in the list */
int ls_count(list_t *ls)
{
  return ls->num;
}

/* search for an item in the list */
void *ls_search(list_t *ls, int (*cmp)(void*,void*), void *data)
{
  void *ptr = ls_head(ls);
  do {
    if ((*cmp)(ptr,data) == 0)
      return ptr;
    ptr = ls_next(ls);
  } while (ptr);
  return 0;
}
