/* $Id: ls_trav.c,v 0.1 1997/08/18 17:18:08 rsmit06 Exp rsmit06 $
 *
 * This file contains the implementation of the list manipulation routines 
 * from the list library.
 *
 * Copyright (C) 1997  R.F. Smith
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: ls_trav.c,v $
 * Revision 0.1  1997/08/18 17:18:08  rsmit06
 * Initial code.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "list.h"

void *ls_head(list_t *ls)
{
  ls->ptr = ls->head;
  return ls->ptr;
}

void *ls_tail(list_t *ls)
{
  ls->ptr = ls->tail;
  return ls->ptr;
}

void *ls_next(list_t *ls)
{
  if (ls->ptr == 0 || ((link_t*)ls->ptr)->next == 0)
    return 0;
  ls->ptr = ((link_t*)ls->ptr)->next;
  return ls->ptr;
}

void *ls_prev(list_t *ls)
{
  if (ls->ptr == 0|| ((link_t*)ls->ptr)->prev == 0)
    return 0;
  ls->ptr = ((link_t*)ls->ptr)->prev;
  return ls->ptr;
}
