/* $Id: ls_rm.c,v 0.1 1997/08/18 19:10:16 rsmit06 Exp rsmit06 $
 *
 * This file contains the implementation of the list manipulation routines 
 * from the list library.
 *
 * Copyright (C) 1997  R.F. Smith
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: ls_rm.c,v $
 * Revision 0.1  1997/08/18 19:10:16  rsmit06
 * Initial code.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "list.h"

/* remove from head of the list  */
void *ls_rmhead(list_t *ls)
{
  link_t *head = (link_t*)ls->head;
  link_t *oldlink = head;
  /* check for empty list */
  if (ls == 0 || ls->head == 0)
    return 0;
  /* handle list with single element */
  if (ls->head == ls->tail) {
    ls->head = ls->tail = ls->ptr = 0;
    ls->num = 0;
    goto old_head;
  }
  /* update anchor structure */
  if (ls->ptr == ls->head)
    ls->ptr = (void*)head->next;
  ls->head = (void*)head->next;
  ls->num--;
  /* set new head of the list*/
  head = head->next; head->prev = 0;
old_head:
  /* update old head */
  oldlink->next = oldlink->prev = 0;
  return (void*)oldlink;
}

/* remove from tail of the list */
void *ls_rmtail(list_t *ls)
{
  link_t *tail = (link_t*)ls->tail;
  link_t *oldlink = tail;
  /* check for empty list */
  if (ls == 0 || ls->tail == 0)
    return 0;
  /* handle list with single element */
  if (ls->head == ls->tail) {
    ls->head = ls->tail = ls->ptr = 0;
    ls->num = 0;
    goto old_tail;
  }
  /* update anchor structure */
  if (ls->ptr == ls->tail)
    ls->ptr = (void*)tail->prev;
  ls->tail = (void*)tail->prev;
  ls->num--;
  /* set new tail of the list*/
  tail = tail->prev; tail->next = 0;
old_tail:
  /* update old tail */
  oldlink->next = oldlink->prev = 0;
  return (void*)oldlink;
}

/* remove from any place in the list */
void ls_rm(list_t *ls, void *link)
{
  /* check for empty list */
  if (ls == 0 || ls->head == 0)
    return;
  /* fins and remove element */
  if (ls_find(ls, link)) {
    if (link == ls->head) { /* at the head of the list */
      ls_rmhead(ls);
    } else if (link == ls->tail) { /* at the tail of the list */
      ls_rmtail(ls);
    } else {
      link_t *pl = (link_t*)link;
      link_t *prev = pl->prev, *next = pl->next;
      prev->next = next; next->prev = prev;
      pl->next = pl->prev = 0;
      ls->num--;
      if (link == ls->ptr) {
        if (next)
          ls->ptr = (void*)next;
        else
          ls->ptr = (void*)prev;
      }
    }
  }
}










