/* $Id: ls_init.c,v 0.1 1997/08/18 16:31:11 rsmit06 Exp rsmit06 $
 *
 * This file contains the implementation of the list intialization 
 * routines from the list library.
 *
 * Copyright (C) 1997  R.F. Smith
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: ls_init.c,v $
 * Revision 0.1  1997/08/18 16:31:11  rsmit06
 * Initial code.
 *
 */

#include <stdlib.h>
#include "list.h"

/* initializes a list */
void ls_init(list_t *ls)
{
  ls->head = ls->tail = 0;
  ls->num = 0;
}

/* allocates space for a list entry using calloc */
void *ls_alloc(unsigned size)
{
  link_t *plink = (link_t *)calloc(1, size);
  if (plink == 0)
    return 0;
  plink->next = plink->prev = 0;
  plink->xtra = 0;
  return (void*)plink;
}

/* deletes a list, free-ing all entries. */
void ls_delete(list_t *ls)
{
  void *rv = ls_rmhead(ls);
  while (rv) {
    free(rv);
    rv = ls_rmhead(ls);
  } 
}

/* gives the address of the xtra value */
int *ls_xtra(void *link)
{
  link_t *l = (link_t*)link;
  return &l->xtra;
}

