/* $Id: ls_add.c,v 0.2 1997/08/21 07:20:30 rsmit06 Exp rsmit06 $
 *
 * This file contains the implementation of the list manipulation routines 
 * from the list library.
 *
 * Copyright (C) 1997  R.F. Smith
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: ls_add.c,v $
 * Revision 0.2  1997/08/21 07:20:30  rsmit06
 * Bugfix: prepend was appending and v.v. Code looks stable.
 *
 * Revision 0.1  1997/08/18 18:10:29  rsmit06
 * Initial code.
 *
 */

#include "list.h"

/* add at the head of the list */
void ls_prepend(list_t *ls, void *newlink)
{
  link_t *pl = (link_t*) newlink;

  if (ls->head == 0) { /* empty list */
    ls->head = ls->tail = ls->ptr = newlink;
    ls->num = 1;
    pl->prev = pl->next = 0;
  } else {
    link_t *phead = (link_t*)ls->head;
    /* set new link's pointers */
    pl->prev = 0; pl->next = phead;
    /* set pointer in old head */
    phead->prev = pl;
    /* change ptr if necessary */
    if (ls->ptr == ls->head)
      ls->ptr = newlink;
    /* set new head */
    ls->head = newlink;
    ls->num++;
  }
}

/* add at the tail of the list */
void ls_append(list_t *ls, void *newlink)
{
  link_t *pl = (link_t*) newlink;

  if (ls->tail == 0) { /* empty list */
    ls->head = ls->tail = ls->ptr = newlink;
    ls->num = 1;
    pl->prev = pl->next = 0;
  } else {
    link_t *ptail = (link_t*)ls->tail;
    /* set new link's pointers */
    pl->prev = ptail; pl->next = 0;   ;
    /* set pointer in old head */
    ptail->next = pl;
    /* change ptr if necessary */
    if (ls->ptr == ls->tail)
      ls->ptr = newlink;
    /* set new tail */
    ls->tail = newlink;
    ls->num++;
  }
}

/* add before a certain position in the list. */
void ls_prepend_at(list_t *ls, void *pos, void *newlink)
{
  link_t *lpos = (link_t*)pos;
  link_t *prev = lpos->prev;
  link_t *pl = (link_t*)newlink;
  
  if (ls_find(ls,pos) == 0)
    return; /* not part of the list! */

  if (pos == ls->head) { /* use ls_prepend */
    ls_prepend(ls, newlink);
    return;
  }

  pl->next = lpos; pl->prev = prev;
  lpos->prev = pl; prev->next = pl;
  ls->num++;
}

/* add after a certain position in the list. */
void ls_append_at(list_t *ls, void *pos, void *newlink)
{
  link_t *lpos = (link_t*)pos;
  link_t *next = lpos->next;
  link_t *pl = (link_t*)newlink;
  
  if (ls_find(ls,pos) == 0)
    return; /* not part of the list! */

  if (pos == ls->tail) { /* use ls_append */
    ls_append(ls, newlink);
    return;
  }

  pl->prev = lpos; pl->next = next;
  lpos->next = pl; next->prev = pl;
  ls->num++;
}

