/* $Id: list.h,v 0.1 1997/08/18 16:21:38 rsmit06 Exp rsmit06 $
 *
 * Header file for double linked list library.
 *
 * Copyright (C) 1997  R.F. Smith
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: list.h,v $
 * Revision 0.1  1997/08/18 16:21:38  rsmit06
 * Initial code.
 *
 */

#ifndef LIST_H
#define LIST_H

/* Link structure. This should be included (inherited) as first member
   in a structure for it to be included in a list. */
typedef struct _link {
  struct _link *prev, *next;
  int xtra;
} link_t;

/* list anchor point. */
typedef struct {
  void *head, *tail;
  void *ptr;
  int num;
} list_t;

/* initializes a list */
void ls_init(list_t *ls);
/* allocates space for a list entry using calloc */
void *ls_alloc(unsigned size);
/* deletes a list, free-ing all entries. */
void ls_delete(list_t *ls);
/* gives the address of the xtra value */
int *ls_xtra(void *link);

/* list traversal functions */
void *ls_head(list_t *ls);
void *ls_tail(list_t *ls);
void *ls_next(list_t *ls);
void *ls_prev(list_t *ls);

/* look if pointer points to a link in the list */
int ls_find(list_t *ls, void *islink);
/* get the count of the number of elements in the list */
int ls_count(list_t *ls);
/* search for an item in the list */
void *ls_search(list_t *ls, int (*cmp)(void*,void*), void *data);

/* add at the tail of the list */
void ls_append(list_t *ls, void *newlink);
/* add at the head of the list */
void ls_prepend(list_t *ls, void *newlink);
/* add before a certain position in the list. */
void ls_prepend_at(list_t *ls, void *pos, void *newlink);
/* add after a certain position in the list. */
void ls_append_at(list_t *ls, void *pos, void *newlink);

/* remove from head of the list  */
void *ls_rmhead(list_t *ls);
/* remove from tail of the list */
void *ls_rmtail(list_t *ls);
/* remove from any place in the list */
void ls_rm(list_t *ls, void *link);

#endif /* LIST_H */


