/* $Id: launch_test.c,v 1.1 2001/02/04 21:34:35 rsmith Exp $
 * -*- c -*-
 * This file is a test program for the launch module.
 * Copyright (C) 2001  R.F. Smith <rsmith@xs4all.nl>
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this code; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * $Log: launch_test.c,v $
 * Revision 1.1  2001/02/04 21:34:35  rsmith
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "launch.h"

#ifndef NULL
#define NULL (void*)0
#endif

#ifndef RETURN_IF_FAIL
#define RETURN_IF_FAIL(test) if (!(test)) return
#endif

#ifndef RETURN_VAL_IF_FAIL
#define RETURN_VAL_IF_FAIL(test,val) if (!(test)) return ((val))
#endif

int main (int argc, char *argv[])
{
  program_t yes;
  int rc;

  yes.name = "/usr/bin/yes";

  rc = launch_program (&yes);
  if (rc == 0)
    {
      printf ("%s lauched successfully. PID = %d\n", yes.name, yes.pid);
      kill_program (&yes);
      printf ("%s killed. PID = %d\n", yes.name, yes.pid);
    }
  return 0;
}

/* EOF $RCSfile: launch_test.c,v $ */
