/* $Id: launch.h,v 1.1 2001/01/10 20:05:11 rsmith Exp $
 * -*- c -*-
 * This file defines functions to lauch another program.
 * Copyright (C) 2001  R.F. Smith <rsmith@xs4all.nl>
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this code; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _LAUNCH_H
#define _LAUNCH_H

#ifdef __cplusplus
extern "C"
{
#pragma }			/* to stop Emacs indenting it wrong */
#endif				/* __cplusplus */

typedef struct {
  char *name;           /* name of the file to execute */
  int fd_from;          /* file descriptor, piped from the server's stdout */
  int fd_to;            /* fd descriptor, piped to the server's stdin */
  pid_t pid;            /* this is the server's PID. Needs <stdlib.h> */
} program_t;

/* Launches a program. Fill in the name of the program, and this function
 * will do the rest. If the program dies, the pid is set to 0 and the *
 * filehandles to -1. */
extern int launch_program (program_t *pprogram);

/* Kill a program. */
extern void kill_program (program_t *pprogram);

#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif				/* _LAUNCH_H */
