
/*
 * Transliteration table
 */

static const unsigned char translit_data[754] = {
   1, ' ',
   1, '!',
   1, 'c',
   2, 'l', 'b',
   3, 'y', 'e', 'n',
   1, '|',
   2, 'S', 'S',
   1, '"',
   3, '(', 'c', ')',
   1, 'a',
   2, '<', '<',
   3, 'n', 'o', 't',
   1, '-',
   3, '(', 'R', ')',
   2, '^', '0',
   3, '+', '/', '-',
   2, '^', '2',
   2, '^', '3',
   1,'\'',
   1, 'u',
   1, 'P',
   1, '.',
   1, ',',
   2, '^', '1',
   1, 'o',
   2, '>', '>',
   3, '1', '/', '4',
   3, '1', '/', '2',
   3, '3', '/', '4',
   1, '?',
   2, '`', 'A',
   2,0xB4, 'A',
   2, '^', 'A',
   2, '~', 'A',
   2, '"', 'A',
   1, 'A',
   2, 'A', 'E',
   1, 'C',
   2, '`', 'E',
   2,0xB4, 'E',
   2, '^', 'E',
   2, '"', 'E',
   2, '`', 'I',
   2,0xB4, 'I',
   2, '^', 'I',
   2, '"', 'I',
   1, 'D',
   2, '~', 'N',
   2, '`', 'O',
   2,0xB4, 'O',
   2, '^', 'O',
   2, '~', 'O',
   2, '"', 'O',
   1, 'x',
   1, 'O',
   2, '`', 'U',
   2,0xB4, 'U',
   2, '^', 'U',
   2, '"', 'U',
   2,0xB4, 'Y',
   2, 'T', 'h',
   2, 's', 's',
   2, '`', 'a',
   2,0xB4, 'a',
   2, '^', 'a',
   2, '~', 'a',
   2, '"', 'a',
   1, 'a',
   2, 'a', 'e',
   1, 'c',
   2, '`', 'e',
   2,0xB4, 'e',
   2, '^', 'e',
   2, '"', 'e',
   2, '`', 'i',
   2,0xB4, 'i',
   2, '^', 'i',
   2, '"', 'i',
   1, 'd',
   2, '~', 'n',
   2, '`', 'o',
   2,0xB4, 'o',
   2, '^', 'o',
   2, '~', 'o',
   2, '"', 'o',
   1, ':',
   1, 'o',
   2, '`', 'u',
   2,0xB4, 'u',
   2, '^', 'u',
   2, '"', 'u',
   2,0xB4, 'y',
   2, 't', 'h',
   2, '"', 'y',
   1, 'A',
   1, 'a',
   1, 'A',
   1, 'a',
   1, 'A',
   1, 'a',
   2,0xB4, 'C',
   2,0xB4, 'c',
   2, '^', 'C',
   2, '^', 'c',
   1, 'C',
   1, 'c',
   1, 'C',
   1, 'c',
   1, 'D',
   1, 'd',
   1, 'D',
   1, 'd',
   1, 'E',
   1, 'e',
   1, 'E',
   1, 'e',
   1, 'E',
   1, 'e',
   1, 'E',
   1, 'e',
   1, 'E',
   1, 'e',
   2, '^', 'G',
   2, '^', 'g',
   1, 'G',
   1, 'g',
   1, 'G',
   1, 'g',
   1, 'G',
   1, 'g',
   2, '^', 'H',
   2, '^', 'h',
   1, 'H',
   1, 'h',
   2, '~', 'I',
   2, '~', 'i',
   1, 'I',
   1, 'i',
   1, 'I',
   1, 'i',
   1, 'I',
   1, 'i',
   1, 'I',
   1, 'i',
   2, 'I', 'J',
   2, 'i', 'j',
   2, '^', 'J',
   2, '^', 'j',
   1, 'K',
   1, 'k',
   1, 'L',
   1, 'l',
   1, 'L',
   1, 'l',
   1, 'L',
   1, 'l',
   1, 'L',
   1, 'l',
   1, 'L',
   1, 'l',
   2,0xB4, 'N',
   2,0xB4, 'n',
   1, 'N',
   1, 'n',
   1, 'N',
   1, 'n',
   2,'\'', 'n',
   1, 'O',
   1, 'o',
   1, 'O',
   1, 'o',
   2, '"', 'O',
   2, '"', 'o',
   2, 'O', 'E',
   2, 'o', 'e',
   2,0xB4, 'R',
   2,0xB4, 'r',
   1, 'R',
   1, 'r',
   1, 'R',
   1, 'r',
   2,0xB4, 'S',
   2,0xB4, 's',
   2, '^', 'S',
   2, '^', 's',
   1, 'S',
   1, 's',
   1, 'S',
   1, 's',
   1, 'T',
   1, 't',
   1, 'T',
   1, 't',
   1, 'T',
   1, 't',
   2, '~', 'U',
   2, '~', 'u',
   1, 'U',
   1, 'u',
   1, 'U',
   1, 'u',
   1, 'U',
   1, 'u',
   2, '"', 'U',
   2, '"', 'u',
   1, 'U',
   1, 'u',
   2, '^', 'W',
   2, '^', 'w',
   2, '^', 'Y',
   2, '^', 'y',
   2, '"', 'Y',
   2,0xB4, 'Z',
   2,0xB4, 'z',
   1, 'Z',
   1, 'z',
   1, 'Z',
   1, 'z',
   1, 'S',
   1, 'f',
   1, 'S',
   1, 's',
   1, 'T',
   1, 't',
   1, '^',
   1, '~',
   1, '"',
   1, 'B',
   1, 'b',
   1, 'D',
   1, 'd',
   1, 'F',
   1, 'f',
   1, 'M',
   1, 'm',
   1, 'P',
   1, 'p',
   1, 'S',
   1, 's',
   1, 'T',
   1, 't',
   2, '`', 'W',
   2, '`', 'w',
   2,0xB4, 'W',
   2,0xB4, 'w',
   2, '"', 'W',
   2, '"', 'w',
   2, '`', 'Y',
   2, '`', 'y',
   1, '-',
   1, '-',
   1, '-',
   1, '-',
   1, '-',
   1, '-',
   1, '"',
   1, '"',
   1, '"',
   1, '+',
   1, 'o',
   3, '.', '.', '.',
   4, 'o', '/', 'o', 'o',
   1,0xB4,
   2,0xB4,0xB4,
   3,0xB4,0xB4,0xB4,
   1, '<',
   1, '>',
   3, 'E', 'U', 'R',
   3, 'N', 'o', '.',
   2, 'T', 'M',
   3, 'O', 'h', 'm',
   3, '1', '/', '8',
   3, '3', '/', '8',
   3, '5', '/', '8',
   3, '7', '/', '8',
   2, '<', '-',
   1, '^',
   2, '-', '>',
   1, 'V',
   2, '<', '=',
   2, '=', '>',
   1, '-',
   1, '/',
   2, '/', '=',
   2, '<', '=',
   2, '>', '=',
   2, '<', '<',
   2, '>', '>',
   1, '-',
   1, '|',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
};

static const short translit_page00[248] = {
    0,   2,   4,   6,  -1,   9,  13,  15, /* 0xa0-0xa7 */
   18,  20,  24,  26,  29,  33,  35,  -1, /* 0xa8-0xaf */
   39,  42,  46,  49,  52,  54,  56,  58, /* 0xb0-0xb7 */
   60,  62,  65,  67,  70,  74,  78,  82, /* 0xb8-0xbf */
   84,  87,  90,  93,  96,  99, 101, 104, /* 0xc0-0xc7 */
  106, 109, 112, 115, 118, 121, 124, 127, /* 0xc8-0xcf */
  130, 132, 135, 138, 141, 144, 147, 150, /* 0xd0-0xd7 */
  152, 154, 157, 160, 163, 166, 169, 172, /* 0xd8-0xdf */
  175, 178, 181, 184, 187, 190, 192, 195, /* 0xe0-0xe7 */
  197, 200, 203, 206, 209, 212, 215, 218, /* 0xe8-0xef */
  221, 223, 226, 229, 232, 235, 238, 241, /* 0xf0-0xf7 */
  243, 245, 248, 251, 254, 257, 260, 263, /* 0xf8-0xff */
  /* 0x0100 */
  266, 268, 270, 272, 274, 276, 278, 281, /* 0x00-0x07 */
  284, 287, 290, 292, 294, 296, 298, 300, /* 0x08-0x0f */
  302, 304, 306, 308, 310, 312, 314, 316, /* 0x10-0x17 */
  318, 320, 322, 324, 326, 329, 332, 334, /* 0x18-0x1f */
  336, 338, 340, 342, 344, 347, 350, 352, /* 0x20-0x27 */
  354, 357, 360, 362, 364, 366, 368, 370, /* 0x28-0x2f */
  372, 374, 376, 379, 382, 385, 388, 390, /* 0x30-0x37 */
   -1, 392, 394, 396, 398, 400, 402, 404, /* 0x38-0x3f */
  406, 408, 410, 412, 415, 418, 420, 422, /* 0x40-0x47 */
  424, 426,  -1,  -1, 429, 431, 433, 435, /* 0x48-0x4f */
  437, 440, 443, 446, 449, 452, 455, 457, /* 0x50-0x57 */
  459, 461, 463, 466, 469, 472, 475, 477, /* 0x58-0x5f */
  479, 481, 483, 485, 487, 489, 491, 493, /* 0x60-0x67 */
  495, 498, 501, 503, 505, 507, 509, 511, /* 0x68-0x6f */
  513, 516, 519, 521, 523, 526, 529, 532, /* 0x70-0x77 */
  535, 538, 541, 544, 546, 548, 550, 552, /* 0x78-0x7f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x80-0x87 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x88-0x8f */
   -1,  -1, 554,  -1,  -1,  -1,  -1,  -1, /* 0x90-0x97 */
};
static const short translit_page02[8] = {
  556, 558, 560, 562,  -1,  -1,  -1,  -1, /* 0x18-0x1f */
};
static const short translit_page02_1[32] = {
   -1,  -1,  -1,  -1,  -1,  -1, 564,  -1, /* 0xc0-0xc7 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0xc8-0xcf */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0xd0-0xd7 */
   -1,  -1,  -1,  -1, 566, 568,  -1,  -1, /* 0xd8-0xdf */
};
static const short translit_page1e[136] = {
   -1,  -1, 570, 572,  -1,  -1,  -1,  -1, /* 0x00-0x07 */
   -1,  -1, 574, 576,  -1,  -1,  -1,  -1, /* 0x08-0x0f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x10-0x17 */
   -1,  -1,  -1,  -1,  -1,  -1, 578, 580, /* 0x18-0x1f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x20-0x27 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x28-0x2f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x30-0x37 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x38-0x3f */
  582, 584,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x40-0x47 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x48-0x4f */
   -1,  -1,  -1,  -1,  -1,  -1, 586, 588, /* 0x50-0x57 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x58-0x5f */
  590, 592,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x60-0x67 */
   -1,  -1, 594, 596,  -1,  -1,  -1,  -1, /* 0x68-0x6f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x70-0x77 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x78-0x7f */
  598, 601, 604, 607, 610, 613,  -1,  -1, /* 0x80-0x87 */
};
static const short translit_page1e_2[8] = {
   -1,  -1, 616, 619,  -1,  -1,  -1,  -1, /* 0xf0-0xf7 */
};
static const short translit_page20[48] = {
  622, 624, 626, 628, 630, 632,  -1,  -1, /* 0x10-0x17 */
   -1,  -1,  -1,  -1, 634, 636, 638,  -1, /* 0x18-0x1f */
  640,  -1, 642,  -1,  -1,  -1, 644,  -1, /* 0x20-0x27 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x28-0x2f */
  648,  -1, 653, 655, 658,  -1,  -1,  -1, /* 0x30-0x37 */
   -1, 662, 664,  -1,  -1,  -1,  -1,  -1, /* 0x38-0x3f */
};
static const short translit_page21[200] = {
   -1,  -1,  -1,  -1,  -1,  -1, 670,  -1, /* 0x10-0x17 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x18-0x1f */
   -1,  -1, 674,  -1,  -1,  -1, 677,  -1, /* 0x20-0x27 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x28-0x2f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x30-0x37 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x38-0x3f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x40-0x47 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x48-0x4f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x50-0x57 */
   -1,  -1,  -1, 681, 685, 689, 693,  -1, /* 0x58-0x5f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x60-0x67 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x68-0x6f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x70-0x77 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x78-0x7f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x80-0x87 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x88-0x8f */
  697, 700, 702, 705,  -1,  -1,  -1,  -1, /* 0x90-0x97 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0x98-0x9f */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0xa0-0xa7 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0xa8-0xaf */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0xb0-0xb7 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0xb8-0xbf */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0xc0-0xc7 */
   -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, /* 0xc8-0xcf */
  707,  -1, 710,  -1,  -1,  -1,  -1,  -1, /* 0xd0-0xd7 */
};
static const short translit_page22[8] = {
   -1,  -1, 713,  -1,  -1, 715,  -1,  -1, /* 0x10-0x17 */
};
static const short translit_page22_3[16] = {
  717,  -1,  -1,  -1, 720, 723,  -1,  -1, /* 0x60-0x67 */
   -1,  -1, 726, 729,  -1,  -1,  -1,  -1, /* 0x68-0x6f */
};
static const short translit_page25[64] = {
  732,  -1, 734,  -1,  -1,  -1,  -1,  -1, /* 0x00-0x07 */
   -1,  -1,  -1,  -1, 736,  -1,  -1,  -1, /* 0x08-0x0f */
  738,  -1,  -1,  -1, 740,  -1,  -1,  -1, /* 0x10-0x17 */
  742,  -1,  -1,  -1, 744,  -1,  -1,  -1, /* 0x18-0x1f */
   -1,  -1,  -1,  -1, 746,  -1,  -1,  -1, /* 0x20-0x27 */
   -1,  -1,  -1,  -1, 748,  -1,  -1,  -1, /* 0x28-0x2f */
   -1,  -1,  -1,  -1, 750,  -1,  -1,  -1, /* 0x30-0x37 */
   -1,  -1,  -1,  -1, 752,  -1,  -1,  -1, /* 0x38-0x3f */
};

#define translit_index(wc) \
  (wc >= 0x00a0 && wc < 0x0198 ? translit_page00[wc-0x00a0] : \
   wc >= 0x0218 && wc < 0x0220 ? translit_page02[wc-0x0218] : \
   wc >= 0x02c0 && wc < 0x02e0 ? translit_page02_1[wc-0x02c0] : \
   wc >= 0x1e00 && wc < 0x1e88 ? translit_page1e[wc-0x1e00] : \
   wc >= 0x1ef0 && wc < 0x1ef8 ? translit_page1e_2[wc-0x1ef0] : \
   wc >= 0x2010 && wc < 0x2040 ? translit_page20[wc-0x2010] : \
   wc == 0x20ac ? 666 : \
   wc >= 0x2110 && wc < 0x21d8 ? translit_page21[wc-0x2110] : \
   wc >= 0x2210 && wc < 0x2218 ? translit_page22[wc-0x2210] : \
   wc >= 0x2260 && wc < 0x2270 ? translit_page22_3[wc-0x2260] : \
   wc >= 0x2500 && wc < 0x2540 ? translit_page25[wc-0x2500] : \
   -1)
