///-*-C++-*-//////////////////////////////////////////////////////////////////
//
// Hoard: A Fast, Scalable, and Memory-Efficient Allocator
//        for Shared-Memory Multiprocessors
// Contact author: Emery Berger, http://www.cs.utexas.edu/users/emery
//
// Copyright (c) 1998, 1999, The University of Texas at Austin.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation, http://www.fsf.org.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef _WRAPPER_H_
#define _WRAPPER_H_

#include "config.h"
#include "processheap.h"

class wrapper {
public:
  // Return the process heap.
  // We make this a static to force it to be
  // initialized properly before its first use.
  static processHeap * TheAllocator (void) {
    static processHeap TheRealAllocator;
    return &TheRealAllocator;
  }

private:

  // Disable copying and assignment.

  wrapper (const wrapper&);
  const wrapper& operator= (const wrapper&);

};


#endif // _WRAPPER_H_

