#include <iostream.h>
#include <math.h>

#include "config.h"
#include "heap.h"

// Use this procedure to rebuild the _sizeTable initialization
// in heap.cpp if SIZE_CLASSES, ALIGNMENT, or SIZE_CLASS_BASE changes.

int main (int, char **)
{
  cout << "{";

  const unsigned long maxUL = (unsigned long) -1;
  int j = 0;
  float sz = 0.0;
  while (j < hoardHeap::SIZE_CLASSES) {
    // Initialize the size class lookup table.
    float newSize = hoardHeap::align (ceil(pow(SIZE_CLASS_BASE, j)));
    if (sz != newSize) {
      sz = newSize;
      if (sz > (float) maxUL) {
	cout << maxUL << "UL";
      } else {
	cout << (unsigned long) sz << "UL";
      }
      if (j < hoardHeap::SIZE_CLASSES - 1) {
	cout << ", ";
      }
    }
    j++;
  }

  cout << "}; " << endl;
}
