///-*-C++-*-//////////////////////////////////////////////////////////////////
//
// Hoard: A Fast, Scalable, and Memory-Efficient Allocator
//        for Shared-Memory Multiprocessors
// Contact author: Emery Berger, http://www.cs.utexas.edu/users/emery
//
// Copyright (c) 1998, 1999, The University of Texas at Austin.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation, http://www.fsf.org.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef _ARCH_SPECIFIC_H_
#define _ARCH_SPECIFIC_H_

#include "config.h"


// Wrap architecture-specific functions.

#if defined(WIN32) || defined(__WIN32__) || defined(_WIN32)
#ifndef WIN32
#define WIN32 1
#endif
#include <windows.h>
#include <process.h>
typedef LONG	hoardLockType;
typedef HANDLE 	hoardThreadType;

#else // not Windows

#if USE_SPROC

#include <sys/types.h>
#include <sys/prctl.h>

#else

#include <pthread.h>
#include <unistd.h>

#endif

#if USER_LOCKS && (defined(i386) || defined(sparc) || defined(__sgi))
typedef unsigned long	hoardLockType;
#else
typedef pthread_mutex_t	hoardLockType;
#endif

#if USE_SPROC
typedef pid_t			hoardThreadType;
#else
typedef pthread_t		hoardThreadType;
#endif

#endif

///// Thread-related wrappers.

void	hoardCreateThread (hoardThreadType& t,
			   void *(*function) (void *),
			   void * arg);
void	hoardJoinThread (hoardThreadType& t);
int	hoardGetThreadID (void);

///// Lock-related wrappers.

void	hoardLockInit (hoardLockType& lock);
void	hoardLock (hoardLockType& lock);
void	hoardUnlock (hoardLockType& lock);

// Returns 0 when the lock has been successfully acquired.
int	hoardTryLock (hoardLockType& lock);

///// Memory-related wrapper.

int	hoardGetPageSize (void);
void *	hoardSbrk (long size);

#endif // _ARCH_SPECIFIC_H_

