/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 thomas harrer.
** -------------------------------------------------------------------- *
**
**  software:		xmhelp - standalone help system
**
**  author: 		thomas harrer
**			thomas.harrer@rus.uni-stuttgart.de
**
** -------------------------------------------------------------------- *
*h  $Id: xmhelp.h,v 1.3 1995/02/27 10:47:18 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		xmhelp.h
**
**  contents:		global (misc) definitions for help
**
**  interface:		could be included via preprocessor #include
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _XMHELP_H_
#define _XMHELP_H_ 1

/* -------------------------------------------------------------------- *
*g  include files
** -------------------------------------------------------------------- */
#include <X11/Intrinsic.h>	/* for Widget.				*/
#include <stdio.h>		/* for fprintf in checked allocation	*/
				/* macros.				*/
#include <stdlib.h>		/* for EXIT_FAILURE.			*/
#include <string.h>		/* for strdup.				*/

/* -------------------------------------------------------------------- *
*g  editres support
** -------------------------------------------------------------------- */
/* editres support  */
#if (XtSpecificationRelease > 4)
# define EDITRES_SUPPORT
# include <X11/Xmu/Editres.h>
#endif
#ifdef EDITRES_SUPPORT
# define editres_support(_shell)					\
    XtAddEventHandler (_shell, (EventMask) 0, TRUE,			\
		       (XtEventHandler) _XEditResCheckMessages, NULL)
#else
# define editres_support(_shell) 
#endif /* EDITRES_SUPPORT  */

/* -------------------------------------------------------------------- *
*g  definitions
** -------------------------------------------------------------------- */
/* define EXIT_FAILURE if not already defined.: */
/* (on some systems it is not in stdlib.h). */

#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS 0
#endif /* !EXIT_SUCCESS */

#ifndef EXIT_FAILURE
# define EXIT_FAILURE 1
#endif /* !EXIT_FAILURE */

/* -------------------------------------------------------------------- *
*g  global definitions
** -------------------------------------------------------------------- */
#define public /* nothing */
#define private static 

/* -------------------------------------------------------------------- *
*g  error codes
** -------------------------------------------------------------------- */
#define no_error				0
#define error_out_of_memory 			1
#define error_inconsistency 			2
#define error_cannot_open_display 		3
#define error_no_file_specified			4
#define error_cannot_open_stream		5

/* sequence format errors  */
#define error_sequence_format_unknown		6
#define error_format				7
#define error_more_than_two_dates_in_embl	8

/* Here we should have mapping from error codes to strings */
/* for more than one language.  */
#define fatal_error(code) {						   \
    fprintf (stderr, 							   \
     "Error (code %d) in file %s line %d\na", code,__FILE__, __LINE__);    \
    exit (EXIT_FAILURE);						   \
}

/* -------------------------------------------------------------------- *
*g  allocation macros
** -------------------------------------------------------------------- */
#define checked_malloc(_target,_size,_type) {			\
    _target = (_type *) malloc (sizeof ( _type ) * (_size));	\
    if (_target == NULL) fatal_error (error_out_of_memory);	\
}

#define checked_calloc(_target,_size,_type) {			\
    _target = (_type *) calloc ((_size), sizeof ( _type ));	\
    if (_target == NULL) fatal_error (error_out_of_memory);	\
}

#define checked_realloc(_target,_newsize,_type) {		\
    _type * _tmp_ptr = (_type*)                                 \
            realloc (_target, (_newsize) * sizeof (_type));	\
    if (_tmp_ptr == NULL) {					\
	fatal_error (error_out_of_memory);			\
    } else {							\
	_target = _tmp_ptr;					\
    }								\
}

#define checked_strdup(_target,_src) {				\
    _target = strdup (_src);					\
    if (_target == NULL) fatal_error (error_out_of_memory);	\
}

/* -------------------------------------------------------------------- *
*g  debug output
** -------------------------------------------------------------------- */
#ifdef DEBUG
# define trace(x)	 printf x
# define ftrace(x)	 fprintf x
#else
# define trace(x)	
# define ftrace(x)
#endif /* DEBUG  */

/* -------------------------------------------------------------------- *
*g  fopen mode strings (on some systems "rb" and "wb")
** -------------------------------------------------------------------- */
#ifndef FOPEN_READ
# define FOPEN_READ "r"
#endif /* !FOPEN_READ */

#ifndef FOPEN_WRITE
# define FOPEN_WRITE "w"
#endif /* !FOPEN_WRITE */

#endif /* !_XMHELP_H_ */
/* -------------------------------------------------------------------- *
*L  Emacs:
**  Local Variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  gh-language:	"english"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  End:
** -------------------------------------------------------------------- */
