/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 thomas harrer.
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for osf/motif(tm) applications. 
**  based on libhtmlw from ncsa mosaic version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: xmhelp.c,v 1.11 1995/06/18 13:43:27 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		xmhelp.c
**
**  contents:		standalone help browser.
**
**  interface:		xmhelp [<toolkit options>] [<help-file>]
**			settings can be changed via resources.
**			classname is Xmhelp.
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#include <Xm/Xm.h>
#include <X11/Xos.h>

/* libraries   */
#include <help.h>

#include <signal.h>
#include <unistd.h>
#include "xmhelp.h"

/* -------------------------------------------------------------------- *
*g  Module identification
** -------------------------------------------------------------------- */
#include "version.h"
#ifndef NO_RCSID
static char rcsid [] =
    "$Id: xmhelp.c,v 1.11 1995/06/18 13:43:27 thomas Exp $";
static char release [] = 
    "$Release: " _system_name_ " " _system_version_ " (" _system_date_ ")$";
#endif /* !NO_RCSID */

/* -------------------------------------------------------------------- *
*g  application wide global data
** -------------------------------------------------------------------- */
public Widget toplevel;

/* -------------------------------------------------------------------- *
*g  resource and option strings
** -------------------------------------------------------------------- */
private String fallbacks [] = {
#include "resources.h"
};

/* -------------------------------------------------------------------- *
*p  procedure-name:	client_get_help
**
**  purpose:		sigusr1 signal hander. this can be used to 
**			remote control xmhelp.
**			
**			read thelp document name from file
**			$HOME/.xmhelp.<pid> where <pid> is the process id
**			if the xmhelp process.
** -------------------------------------------------------------------- */
void 
client_get_help (/* i  */ int signal_number)
{
    static pid_t mypid = 0;
    static char* home = NULL;
    static char* name = NULL;
    
    /* while we display the requested help, further requests are ignored. */
    signal (SIGUSR1, SIG_IGN);

    trace (("sigusr1 occured\n"));

    if (!mypid) mypid = getpid ();
    if (!home) checked_strdup (home, getenv ("HOME"));
    
    /* we compose the filename for communication with the client.  */
    if ((!name) && home) {
	char* servername = "xmhelp";
	size_t size = strlen (home) + strlen (servername) + 32;
	checked_malloc (name, size, char);
	sprintf (name, "%s/.%s.%d", home, servername, mypid);
    }
    
    /* now we read the url from the file "name"  */
    if (name) {
	FILE* read = fopen (name, "r"); trace (("opened %s\n", name));
	if (read) {
	    char line[256];
	    if (NULL != fgets (line, 256, read)) {
		get_help (toplevel, line, NULL);
	    }
	    fclose (read);
	    unlink (name);
	} else  {
	    fprintf (stderr, "xmhelp: got SIGUSR1, but no %s found\n", name);
	    fflush (stderr);
	}
    } else  {
	fprintf (stderr, "xmhelp: got SIGUSR1, but could not compose name\n");
	exit (1);
    }

    /* at the end of this function, we allow new requests.  */
    signal (SIGUSR1, client_get_help);
}

/* -------------------------------------------------------------------- *
*p  procedure-name:	main
**
**			start of processing
**			
**  purpose:		this main was thought of as an example for libhelp
**			but now, it is quite a useful standalone 
**			application.
** -------------------------------------------------------------------- */
public int
main (int 	argc,
      char* 	argv[])
{
    /* local data  */
    XtAppContext  app_context;
    char	  class[] = "Xmhelp";
    char	  usage[] = "usage: xmhelp [Xt options] [-update] "
                            "[<help-file>]\n";
    char*	  help_file = "libhelp-index.html";

    /* set libhelp internal resources  */
    help_set_resource (help_class_name, (XtPointer) class); 
    help_set_resource (help_standalone, (XtPointer) 1);
    help_set_resource (help_index, help_file);
    /* 
     * initialize the toolkit, create a toplevel shell.
     * toplevel and display are public for all modules. 
     */
    toplevel = XtVaAppInitialize (&app_context, class, NULL, 0,
				  &argc, argv, fallbacks, NULL);

    /* check the remaining args.  */
    if (argc == 2) {
	help_file = argv[1];
    } else if (argc == 3)  {
	if (0 == strcmp ("-update", argv[1])) {
	    help_set_resource (help_update, (XtPointer) True);
	} else  {
	    fprintf (stderr, usage);
	    exit (EXIT_FAILURE);
	}
	help_file = argv[2];
    } else if (argc > 3) {
	fprintf (stderr, usage);
	exit (EXIT_FAILURE);
    }

    /* Add support for editres to externly get the widget tree.  */
    editres_support (toplevel);

    /* call for help.  */
    get_help (toplevel, help_file, NULL);
    
    XtRealizeWidget (toplevel);
    signal (SIGUSR1, client_get_help);
    XtAppMainLoop (app_context);

    /* XtAppMainLoop never returns.  */
    return 1;
}

/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
