/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for osf/motif(tm) applications. 
**  based on libhtmlw from ncsa mosaic version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**
** -------------------------------------------------------------------- *
*h  $Id: chelp.c,v 1.5 1995/06/18 13:48:27 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		shelp
**
**  contents:		libhelp server example.
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*g  include files
** -------------------------------------------------------------------- */
#include <help.h>
#include <stdio.h>

/* -------------------------------------------------------------------- *
*g  module identification
** -------------------------------------------------------------------- */
#ifndef NO_RCSID
static char rcsid [] =
    "$Id: chelp.c,v 1.5 1995/06/18 13:48:27 thomas Exp $";
#endif /* !NO_RCSID */

/* -------------------------------------------------------------------- *
*p  procedure:		main
** -------------------------------------------------------------------- */
int 
main (/* i  */ int 	argc, 
      /* i  */ char* 	argv[])
{

#ifndef HELP_SERVER
# define HELP_SERVER XMHELP_SERVER
#endif /* !HELP_SERVER */

    int i;
    int st = 3;			/* sleep time */

    if (argc == 2) {
	st = strtol (argv[1], NULL, 10);
	if (st <= 0) st = 1;
    }
    
    help_set_resource (help_server, HELP_SERVER);
    get_help (NULL, "welcome.html", NULL);
    sleep (10 + st);
    for (i = 0; i < 1; i++) {
	get_help (NULL, "libhelp-about.html", NULL); sleep (st);
	get_help (NULL, "libhelp-index.html", NULL); sleep (st);
	get_help (NULL, "libhelp-address.html", NULL); sleep (st);
	get_help (NULL, "libhelp-browser.html", NULL); sleep (st);
	get_help (NULL, "libhelp-buttons.html", NULL); sleep (st);
	get_help (NULL, "libhelp-keys.html", NULL); sleep (st);
	get_help (NULL, "libhelp-search_path.html", NULL); sleep (st);
	get_help (NULL, "libhelp-tharrer.html", NULL); sleep (st);
	get_help (NULL, "libhelp-full_index.html", NULL); sleep (st);
	get_help (NULL, "libhelp-install.html", NULL); sleep (st);
	get_help (NULL, "libhelp-library.html", NULL); sleep (st);
	get_help (NULL, "libhelp-resources.html", NULL); sleep (st);
	get_help (NULL, "libhelp-urls.html", NULL); sleep (st);
	get_help (NULL, "libhelp-example.html", NULL); sleep (st);
	get_help (NULL, "libhelp-context_example.html", NULL); sleep (st);
	get_help (NULL, "libhelp-xmhelp.html", NULL); sleep (st);
	get_help (NULL, "libhelp-libhlpclient.html", NULL); sleep (st);
	get_help (NULL, "libhelp-copyright.html", NULL); sleep (st);
	get_help (NULL, "libButtFace-copyright.html", NULL); sleep (st);
	get_help (NULL, "libXpm-copyright.html", NULL); sleep (st);
	get_help (NULL, "libhtmlw-copyright.html", NULL); sleep (st);
	get_help (NULL, "libhelp-html_mode.html", NULL); sleep (st);
	get_help (NULL, "libhelp-iso-chars.html", NULL); sleep (st);
	get_help (NULL, "libhelp-html.html", NULL); sleep (st);
    }
    return 0;
}

/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
