/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: contexthelp.c,v 1.8 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		context.c
**
**  contents:		context sensitive help
**
**  interface:		functions
**
**	* void context_cb (Widget, XtPointer, XtPointer)
**			
**      * to get context help, specify the following
**
**	  XtAddCallback (widget, XmNhelpCallback, 
**			 (XtCallbackProc) context_cb, 
**			 (XtPointer) cx_*);
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*g  include files
** -------------------------------------------------------------------- */
#include <Xm/Xm.h>
#include "contexthelp.h"
#include "helpp.h"

/* from libhelp  */
#include "help.h"

/* -------------------------------------------------------------------- *
*g  module identification
** -------------------------------------------------------------------- */
#ifdef RCSID
static char rcsid [] =
    "$Id: contexthelp.c,v 1.8 1995/06/28 12:59:30 thomas Exp $";
#endif /* RCSID */

/* -------------------------------------------------------------------- *
*p  private prototypes
** -------------------------------------------------------------------- */
static char*  context_get_help_file (int);

/* -------------------------------------------------------------------- *
*p  procedure-name:	libhelp_context_cb
**
**  purpose:		provides context sensitive help
** -------------------------------------------------------------------- *
**  args:		standard callback args.
**			call_data is actually an integer. 
**			symbols for those are defined in context.h
**  precondition:	callback must be added via XtAddCallback
**  postcondition:	context sensitive help is initiated.
**  error handling.:	-
** -------------------------------------------------------------------- */
void
libhelp_context_cb (/* i  */ Widget 	w,
		    /* i  */ XtPointer 	client_data,
		    /* i  */ XtPointer 	call_data)
{
    /* local data  */
    int 		command = (int) client_data;
    char*		help_file;

    /* get the help file from the help symbol.  */
    help_file = context_get_help_file (command);

    if (help_file != NULL) {
	/*
	 *  we just call libhelp. if there is already a help browser, 
	 *  libhelp uses it. else it creates a new one.
	 */
	(void) get_help (NULL, help_file, NULL);
    }
}

/* -------------------------------------------------------------------- *
*p  procedure-name:	context_get_help_file
**
**  purpose:		return the help file
** -------------------------------------------------------------------- */
static char*
context_get_help_file (/* i  */ int request)
{
    int i = 0;
    
    /* the mapping between context symbols and filenames.  */
    typedef struct context_file_s {
	int	help_symbol;
	char*	filename;
    } context_file_t;

    /* this is the list of errors.  */
    static context_file_t help_list [] =  {
	context_mapping
    };

    while (help_list[i].help_symbol != cx_end) {

	if (help_list[i].help_symbol == request) {
	    return help_list[i].filename;
	}
	i++;

	/* i feel the need for an additional termination condition.  */
	if (i > cx_max) {
	    break;
	}
    }
    return NULL;
}

/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
