/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: actionarea.c,v 1.18 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		actions.c
**
**  contents:		provides an action area based on the button 
**			face library 
**
**  interface:		create_actionarea
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*g  include files
** -------------------------------------------------------------------- */
#include <Xm/RowColumn.h>
#include <pushbuttons.h>

#include "actionarea.h"
#include "helpp.h"		/* for malloc functions. */
#include "contexthelp.h"

/* include the predefined icons  */
#include <dismissU.xpm>
#include <dismissD.xpm>
#include <historyU.xpm>
#include <historyD.xpm>
#include <backU.xpm>
#include <backD.xpm>
#include <upU.xpm>
#include <upD.xpm>
#include <downU.xpm>
#include <downD.xpm>
#include <indexU.xpm>
#include <indexD.xpm>

#ifdef MODULE_TEST
#include <stdio.h>
#include <Xm/PanedW.h>
#endif /* MODULE_TEST  */

/* -------------------------------------------------------------------- *
*g  module identification
** -------------------------------------------------------------------- */
#ifdef RCSID
static char rcsid [] =
    "$Id: actionarea.c,v 1.18 1995/06/28 12:59:30 thomas Exp $";
#endif /* RCSID */

/* -------------------------------------------------------------------- *
*g  actions
** -------------------------------------------------------------------- */
/* type for accessing actions.  */
typedef struct actionrec_s {

    int		action_type;
    Widget	w;

} actionrec_t;

/* global data  */
static actionrec_t* 	actionrec = NULL;
static int		number_of_actions = 0;

/* -------------------------------------------------------------------- *
*p  procedure-name:	create_actionarea
**
**  purpose:		creates buttons with desired bindings
** -------------------------------------------------------------------- *
**  args:		parent widget, 
**  return type:	returns the action area form.
**  precondition:	must be child of manager widget.
**  postcondition:	action area is created and managed.
**  error handling.:	-
** -------------------------------------------------------------------- */
Widget
create_actionarea (/* i  */ Widget 	parent, 
		   /* i  */ action_t* 	actions, 
		   /* i  */ int 	num_actions)
{
    Widget action_area, widget;
    int i;

    if (actionrec != NULL)
	checked_free (actionrec);
    number_of_actions = num_actions;
    checked_malloc (actionrec, number_of_actions, actionrec_t);

    /* create the manager.  */
    action_area = XtVaCreateWidget 
	("action_area", xmRowColumnWidgetClass, parent,
	 XmNorientation, XmHORIZONTAL, 
	 XmNpaneMaximum, 50,
	 XmNpaneMinimum, 50,
	 XmNtraversalOn, False,
	 NULL);

    context_help (action_area, cx_buttons);

    /* create the buttons.  */
    for (i = 0; i < num_actions; i++) {
	char** up = dismissU_xpm;
	char** down = dismissD_xpm;
	
	switch (actions[i].action_type) {
	  case action_dismiss:
	    up = dismissU_xpm;
	    down = dismissD_xpm;
	    break;
	  case action_history:
	    up = historyU_xpm;
	    down = historyD_xpm;
	    break;
	  case action_back:
	    up = backU_xpm;
	    down = backD_xpm;
	    break;
	  case action_up:
	    up = upU_xpm;
	    down = upD_xpm;
	    break;
	  case action_down:
	    up = downU_xpm;
	    down = downD_xpm;
	    break;
	  case action_index:
	    up = indexU_xpm;
	    down = indexD_xpm;
	    break;
	}

	/* create the button for the action  */
	widget = XmCreatePixmapPushButton 
	    (action_area, "button", up, down, NULL, NULL, 0);
	context_help (widget, cx_buttons);
	XtManageChild (widget);

	/* add the actions activate callback.  */
        if (actions[i].callback != NULL)
            XtAddCallback (widget, XmNactivateCallback,
			   actions[i].callback, 
			   (XtPointer) actions[i].action_type);

	/* record the button.  */
	actionrec[i].action_type = actions[i].action_type;
	actionrec[i].w = widget;
    }

    XtManageChild (action_area);

    return action_area;
}

/* -------------------------------------------------------------------- *
*p  procedure-name:	actions_set_sensitive
**
**  purpose:		sets all actions of a specified action_type
**			to the sensitivity state.
** -------------------------------------------------------------------- *
**  args:		action id (only those are available that are
**			declared in actions.h)
**  precondition:	actions must be initialized (else nothing is done).
**  postcondition:	sensitivity state is changed.
** -------------------------------------------------------------------- */
void
actions_set_sensitive (/* i  */ int	action_type,
		       /* i  */ Boolean	sensitive)
{
    if (actionrec != NULL) {

	int i;
	for (i = 0; i < number_of_actions; i++) {
	    if (actionrec[i].action_type == action_type) {
		XtSetSensitive (actionrec[i].w, sensitive);
	    }
	}
    }
}

/* -------------------------------------------------------------------- *
*g  module test:	actionarea
** -------------------------------------------------------------------- */

#ifdef MODULE_TEST
static void 
actionarea_test_cb (Widget w, XtPointer call_data, XtPointer client_data)
{
    printf ("button %d pressed\n", (int) call_data);
    return;
}

#define actionarea_test main
void 
actionarea_test (int argc, char* argv[])
{
    
    /* local data  */
    Widget	toplevel, pane, action_area;
    Display* 	display;
    XtAppContext app_context;
    char	class[] = "Actionarea";

    String 	fallbacks [] = {
	"*Background:  #bfbfbfbfbfbf"
    };

    action_t	actions[] =  {
        {action_dismiss, (XtCallbackProc) actionarea_test_cb, 1},
	{action_history, (XtCallbackProc) actionarea_test_cb, 2},
	{action_back,    (XtCallbackProc) actionarea_test_cb, 3},
	{action_up,      (XtCallbackProc) actionarea_test_cb, 4},
	{action_down,    (XtCallbackProc) actionarea_test_cb, 5},
    };
    /* 
     * initialize the toolkit, create a toplevel shell.
     * toplevel and display are public for all modules. 
     */
    toplevel = XtVaAppInitialize 
	(&app_context, class, NULL, 0,
	 &argc, argv, fallbacks, NULL);
    display = XtDisplay (toplevel);

    pane = XtVaCreateWidget 
	("pane", xmPanedWindowWidgetClass, toplevel,
	 XmNresizePolicy,    		XmRESIZE_ANY,
	 XmNresizable,       		True,
	 NULL);
    
    action_area = create_actionarea (pane, actions, 5);

    XtManageChild (pane);
    XtRealizeWidget (toplevel);
    XtAppMainLoop (app_context);

}
#endif /* MODULE_TEST  */

/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */

