/*
 * pushbuttons.h -- Schoene neue Push-Buttons mit netten Bildchen (Nein,
 *		    nicht das, was Sie jetzt schon wieder denken...!)
 *
 * Version 1.02 vom 03.05.1994
 *
 * (c) 1994 Harald Albrecht
 * Institut fuer Geometrie und Praktische Mathematik
 * albrecht@igpm.rwth-aachen.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING for more details);
 * if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 *
 */
#ifndef __pushbuttons_h
#define __pushbuttons_h

#include <Xm/PushB.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Available push buttons */
#define XmPUSHBUTTON_NONE		0
#define XmPUSHBUTTON_OK			1
#define XmPUSHBUTTON_CANCEL		2
#define XmPUSHBUTTON_ABORT		3
#define XmPUSHBUTTON_RETRY		4
#define XmPUSHBUTTON_IGNORE		5
#define XmPUSHBUTTON_YES		6
#define XmPUSHBUTTON_NO			7
#define XmPUSHBUTTON_HELP		8

/* Available label faces */
#define XmLABELFACE_INFO		0
#define XmLABELFACE_QUESTION		1
#define XmLABELFACE_EXCLAMATION		2
#define XmLABELFACE_HAND		3
#define XmLABELFACE_TIME		4
    
extern void XmAddStandardButtonPixmaps (Widget PushButton, int FaceType);

extern Widget XmCreatePixmapPushButton(Widget Parent, String Name,
                                       char **Normal, char **Armed, 
                                       char **Insensitive,
                                       ArgList Args, Cardinal ArgCount);
extern Widget XmCreatePixmapPushButtonGadget(Widget Parent, String Name,
                                             char **Normal, char **Armed, 
                                             char **Insensitive,
                                             ArgList Args, Cardinal ArgCount);
extern Widget XmCreateStandardPushButton(Widget Parent, String Name, int FaceType,
                                         ArgList Args, Cardinal ArgCount);
extern Widget XmCreateStandardPushButtonGadget(Widget Parent, String Name, int FaceType,
                                               ArgList Args, Cardinal ArgCount);


extern Widget XmCreatePixmapLabel(Widget Parent, String Name, 
                                  char **Normal, char **Insensitive,
                                  ArgList Args, Cardinal ArgCount);
extern Widget XmCreatePixmapLabelGadget(Widget Parent, String Name, 
                                        char **Normal, char **Insensitive,
                                        ArgList Args, Cardinal ArgCount);
extern Widget XmCreateStandardLabel(Widget Parent, String Name, int FaceType,
                                    ArgList Args, Cardinal ArgCount);
extern Widget XmCreateStandardLabelGadget(Widget Parent, String Name, int FaceType,
                                          ArgList Args, Cardinal ArgCount);


#ifdef __cplusplus
}
#endif

#endif
/* Ende von pushbuttons.h */
