;;  -*- emacs-lisp -*-  >
;; --------------------------------------------------------------------
;;  copyright (c) 1995 thomas harrer, ipvr stuttgart.
;; --------------------------------------------------------------------
;;  libhelp  
;; --------------------------------------------------------------------
;h  $Id: libhelp-html.el,v 1.2 1995/06/28 12:12:19 thomas Exp $
;; --------------------------------------------------------------------
;;
;h  module:		libhelp-html.el
;;
;;  contents:		support for writing libhelp documents
;;			also a good example for hooking up emacs to 
;;			make life easier. you probably want to 
;;			edit it to get your own requirements.
;;
;;  interface:		(load-file "libhelp-html.el") or
;;			(require 'libhelp-html)
;;
;; --------------------------------------------------------------------
;;  license and copying issues:
;;
;;  this software is free; you can redistribute it and/or modify it 
;;  under terms similar to the gnu general public license (version 1 
;;  or any later version published by the free software foundation). 
;;  see the file Licence for more details.
;;
;;  this program is distributed in the hope that it will be useful,
;;  but without any warranty; without even the implied warranty of
;;  merchantability or fitness for a particular purpose.  
;; --------------------------------------------------------------------

(defun replace-in-string (string replace-list with-char)
  "Replace occurances of replace-list with with-char in string-"
  (let ((tmp (copy-sequence string))
	(num (+ (length string) -1)))
    (while (>= num 0)
      (if (memq (aref string num) replace-list)
	  (aset tmp num with-char))
      (setq num (- num 1)))
    (eval tmp)))
	
(defvar libhelp-html-author (downcase (user-full-name))
  "name used in copyright section")

(defvar libhelp-html-author-file 
  (concat (replace-in-string (downcase (user-full-name)) '(?\ ) ?-) ".html")
  "html file describing the author.")

(defvar libhelp-html-author-ref 
  (concat "\n<br><a href=\"" libhelp-html-author-file "\">"
	  (user-full-name) "</a>"))

(defun libhelp-html-header ()
  (interactive)
  (let ((title (read-string "title: ")))
    (insert 
     "<html><!--  -*- html -*-  -->\n"
     "<!-- - - - - - - - - - - - - - - - - - - - - - - - - "
     "- - - - - - - -\n"
     "  -  copyright (c) 1995 " libhelp-html-author ".\n" 
     "  -  libhelp help file\n"
     "  -  $I" "d:$\n"
     "  - - - - - - - - - - - - - - - - - - - - - - - - - -"
     " - - - - - - - -->\n<head><title>"
     title   "</title></head>\n<body>\n\n<h1>"
     "<img src=\"libhelp-icon.gif\" alt=\"Libhelp\"> "
     title "</h1>\n\n")))

(defun libhelp-html-trailer ()
  (interactive)
  (insert 
   "<p><img align=\"top\" src=\"libhelp-bar.gif\" alt=\"-----------\">\n"
   "<address>Libhelp version 1.8.1 (Jun 28. 95)."
   libhelp-html-author-ref
   "</address>\n"
   "</body></html>\n"))

(defun libhelp-html-index ()
  (interactive)
  (let ((ref (read-string "reference file: "))
	(item (read-string "index title: ")))
    (insert 
     "<img align=\"top\" src=\"icon-index.gif\" alt=\"+\">\n"
     "  <a href=\"" ref "\">" item "</a><br>\n\n")))

(defun libhelp-html-subindex ()
  (interactive)
  (let ((ref (read-string "reference file: "))
	(item (read-string "index title: ")))
    (insert 
     "<img align=\"top\" src=\"icon-subindex.gif\" alt=\"o\">\n"
     "  <a href=\"" ref "\">"item "</a><br>\n\n")))

(defun libhelp-html-smiley ()
  (interactive)
  (insert 
   "<img src=\"libhelp-smiley.gif\" align=\"top\" alt=\":-)\">"))

(defun libhelp-html-at-work ()
  (interactive)
  (insert 
   "<img src=\"libhelp-atwork.gif\" align=\"top\" alt=\"at work\">"))

(defun libhelp-html-br ()
  (interactive)
  (insert "<br>"))

(cond 
 (window-system
  (require 'easymenu)
  (defconst libhelp-html-menu
    '("Libhelp"
      ["Header..."            libhelp-html-header      t]
      ["Trailer"              libhelp-html-trailer     t]
      ["Index"                libhelp-html-index       t]
      ["Subindex"             libhelp-html-subindex    t]
      ["Smiley"               libhelp-html-smiley      t]
      ["At Work"              libhelp-html-at-work     t]
      "----"
      ["<br>"                 libhelp-html-br          t]
      ))
  (easy-menu-define nil html-mode-map "Libhelp HTML menu" libhelp-html-menu)
  (if menu-bar-final-items
      (setq menu-bar-final-items 
	    (cons 'Libhelp menu-bar-final-items)))
))       
(provide 'libhelp-html)

;; -------------------------------------------------------------------- 
;l  emacs:
;;  local variables:
;;  mode:		emacs-lisp
;;  outline-regexp:	"\;[HGPLT]"
;;  comment-column:	32
;;  eval:		(outline-minor-mode t)
;;  end:
;; -------------------------------------------------------------------- 

