/* $Id: fsm.h,v 0.2 1997/11/16 16:46:46 rsmit06 Exp $
 *
 * Header file for Finite State Machine library (libfsm)
 *
 * Copyright (C) 1997  R.F. Smith
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: fsm.h,v $
 * Revision 0.2  1997/11/16 16:46:46  rsmit06
 * Canged fsm_entry structure.
 *
 * Revision 0.1  1997/11/16 15:04:30  rsmit06
 * Initial code
 *
 */

#ifndef FSM_H
#define FSM_H

/* State transition. Contains the new state and the action to be taken. */
struct fsm_trans {
  unsigned new_state;           /* new state */
  void (*action)(void*);        /* action on this transition */
};

/* Structure used to define transitions. fsm_init uses it to build the
 * the transition table.
 */
struct fsm_entry {
  unsigned state;               /* state to which this transition belongs */
  unsigned input;               /* input on which the transition works */
  unsigned new_state;           /* new state */
  void (*action)(void*);        /* action on this transition */
};

/* FSM structure. */
typedef struct _fsm {
  void *data;                   /* pointer to external data used by the FSM */
  unsigned state_offset;        /* current state of the FSM */
  unsigned input_offset;        /* input value that will be processed */
  unsigned input_available;     /* > 0 if input available */
  unsigned min_state, max_state, num_states;
  unsigned min_input, max_input, num_inputs;
  struct fsm_trans *table;
} *fsm_t;

/* builds the matrix */
fsm_t fsm_init(unsigned num, struct fsm_entry *entries, void *fsm_data);

/* Sets the input for the next FSM run. Returns 1 if previous input hasn't
 * been processed yet..
 * Returns 2 if input is invalid.
 */
int fsm_input(fsm_t fsm, unsigned input);

/* Runs the state machine. Returns 1 in case of illegal input, else 0.
 * Does nothing if no input is available.
 */
int fsm_run(fsm_t fsm);

/* destroys the fsm structure */
void fsm_destroy(fsm_t fsm);

#endif /* FSM_H */
