/*
  Library for reading configuration files
 */

/* Definitions of config styles */
#define CS_GUESS 0
#define CS_LINEVAL 1
#define CS_CAP 2
#define CS_INI 3

#define FALSE 0
#define TRUE !FALSE

/* Error numbers returned by functions */
#define CRET_SUCCESS 0      /* Succeeded */
#define CRET_NEEDFILENAME 1 /* Need a filename, to a read or write */
#define CRET_MEM 2          /* Memory (de)allocation error occurred */
#define CRET_INVALID 3      /* Structure is invalid */
#define CRET_NOTFOUND 4     /* Value not found */
#define CRET_ERRNO 255      /* get error info from errno */


/* These are the types to pass in to config_set and get out of config_get
 */
#define COMMENT_T 1
#define CHARPTR_T 2
#define INT_T 3
#define BOOLEAN_T 4
#define CHARPTRARRAY_T 5
#define LAST_T 6

#ifndef _LIBCONFIG_H
#define _LIBCONFIG_H 1

typedef struct hash_t_s * hash_t;
typedef struct config_t_s * config_t;

/* Creates a new configuration file */
int config_new(config_t *newconf);
int config_destroy(config_t *destconf);

/* Read a config file. filename is required */
int config_read(config_t *readconf, char *filename,
		int style, char **column_names);

/* Write a config file. filename is optional - set to NULL if you want,
 and that will use the filename from config_read */
int config_write(config_t writeconf, char *filename, int style,
		char *keyvalsep);
/* get/set a value. group, key, and column can all legally be NULL */
int config_get(config_t c, char *group, char *key, char *column,
	       int *type, void **value, int *count);
int config_set(config_t c, char *group, char *key, char *column, int type,
               void *value, int count);

/* Need to add things to unset entire groups and/or keys and/or columns
   - right now it just unsets the item matching the specified group/key/column
   */
int config_unset(config_t c, char *group, char *key, char *column);

/* Theoretically returns a pointer to an array of (char *)'s listing the
   columns/groups/keys in the config_t (these are untested lately) */
int config_columns(config_t c, char *group, char *key, char ***collist);
int config_groups(config_t c, char ***grplist);
int config_keys(config_t c, char *group, char ***keylist);
/* I think you are supposed to free the arrays returned by above 3 */
int config_arrayfree(char ***anarray);

/* Dumps debugging info to fp */
#include <stdio.h>
int config_dump(config_t c, FILE *fp);
#endif /* _LIBCONFIG_H */
