/*
  Library for reading configuration files - private declarations
 */
#include "libconfig.h"

#ifndef _CONFIG_PRIVATE_H
#define _CONFIG_PRIVATE_H 1

#include <limits.h>
typedef int boolean;
struct hash_t_s {
  char *key;
  void *value;
  hash_t next;
};

struct config_t_s {
  char *filename, **colnames, *kvsep, *linehead; int flags, style;
  hash_t groups;
};

struct conf_val {
  short unsigned int type;
  union {
    char *charptr_val; /* Also used for comments... */
    int int_val;
    float float_val;
    boolean boolean_val;
    char **charptrarray_val;
  } u;
  short unsigned int count;
};

void config_debug(char *format, ...);
char *xstrdup(char *astring);
void config_val_free(struct conf_val *aval);
void *config_val_get(struct conf_val *aval);

#endif /* _CONFIG_PRIVATE_H */
