/* $Id: comm.h,v 1.3 2001/02/11 10:59:37 rsmith Exp $
 * -*- c -*-
 * This file defines the interface for the comm module. A module for
 * exchanging and processing structured messages between applications.
 * Copyright (C) 2001  R.F. Smith <rsmith@xs4all.nl>
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this code; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * $Log: comm.h,v $
 * Revision 1.3  2001/02/11 10:59:37  rsmith
 * Removed binary messages (not implemented yet).
 *
 * Revision 1.2  2001/02/04 12:18:01  rsmith
 * Added `delim' to the arguments of comm_read_text.
 *
 * Revision 1.1  2001/02/02 19:49:53  rsmith
 * Initial revision
 *
 * 
 */

#ifndef _COMM_H
#define _COMM_H

#ifdef __cplusplus
extern "C" {
#pragma } /* to stop Emacs indenting it wrong */
#endif /* __cplusplus */

typedef struct
{
  char *msgid;
  int (*msg_handler) (char *);
} tcomm_t;      /* text messages */

/* Helper functions for inside the handlers. */
extern int comm_get_int (char **ppstr, int *pres);
extern int comm_get_uint (char **ppstr, unsigned *pres);
extern int comm_get_dbl (char **ppstr, double *pres);

/* Read a text message and dispatch it to the appropriate handler
 * function. The variable `delim' contains the string that denotes the end
 * of the message, e.g. "\n" for a single-line message, or "\n\n" for a
 * multi-lined message.
 */
extern int comm_read_text (int fd, const char *delim, 
                           int num, tcomm_t handlers[]);

/* Write a text message. */
extern int comm_write_text (int fd, char *msgid, char *fmt, ...);

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* _COMM_H */
/* EOF $RCSfile: comm.h,v $ */
